% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.Hull.R
\name{plot.Hull}
\alias{plot.Hull}
\title{Hull Plot}
\usage{
\method{plot}{Hull}(x, i, ...)
}
\arguments{
\item{x}{A \code{list} containing all the information needed to plot the Hull plot. 
It can be gotten from the \code{validation} object when \code{method} = \code{"Hull"}.}

\item{i}{A numeric, which represents the item you want to plot Hull curve.}

\item{...}{Additional arguments to be passed to the plotting function.}
}
\value{
None. This function is used for side effects (plotting).
}
\description{
This function can provide the Hull plot. The points suggested by the Hull method are marked in red.
}
\examples{
set.seed(123)
library(Qval)

## generate Q-matrix and data
K <- 5
I <- 20
IQ <- list(
  P0 = runif(I, 0.1, 0.3),
  P1 = runif(I, 0.7, 0.9)
)

\donttest{
Q <- sim.Q(K, I)
data <- sim.data(Q = Q, N = 500, IQ = IQ, model = "GDINA", distribute = "horder")
MQ <- sim.MQ(Q, 0.1)

CDM.obj <- CDM(data$dat, MQ)

############### ESA ###############
Hull.obj <- validation(data$dat, MQ, CDM.obj, method = "Hull", search.method = "ESA") 
Hull.fit <- Hull.obj$Hull.fit

## plot Hull curve for item 5
plot(Hull.fit, 5)

############### PAA ###############
Hull.obj <- validation(data$dat, MQ, CDM.obj, method = "Hull", search.method = "PAA") 
Hull.fit <- Hull.obj$Hull.fit

## plot Hull curve for item 5
plot(Hull.fit, 5)
}



}
