% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/QuantumClone.R
\name{From_freq_to_cell}
\alias{From_freq_to_cell}
\title{Wrap-up function}
\usage{
From_freq_to_cell(SNV_list, FREEC_list = NULL, Sample_names,
  Genotype_provided = FALSE, save_plot = TRUE, contamination, ncores = 4,
  restrict.to.AB = FALSE, output_directory = NULL,
  force.single.copy = FALSE)
}
\arguments{
\item{SNV_list}{A list of dataframes (one for each sample), with as columns : (for the first column of the first sample the name of the sample),
the chromosome "Chr",the position of the mutation "Start", the number of reads supporting the mutation "Alt", the depth of coverage at this locus "Depth",
and if the output from FREEC for the samples are not associated, the genotype "Genotype".}

\item{FREEC_list}{list of dataframes from FREEC for each samples (usually named Sample_ratio.txt), in the same order as SNV_list}

\item{Sample_names}{Name of the samples}

\item{Genotype_provided}{If the FREEC_list is provided, then should be FALSE (default), otherwise TRUE}

\item{save_plot}{Should the plots be saved? Default is TRUE}

\item{contamination}{Numeric vector describind the contamination in all samples (ranging from 0 to 1). Default is 0. 
No longer used for clustering.}

\item{ncores}{Number of cores to be used during EM algorithm}

\item{restrict.to.AB}{Should the analysis keep only sites located in A and AB sites in all samples?}

\item{output_directory}{Directory in which to save results}

\item{force.single.copy}{Should all mutations in overdiploid regions set to single copy? Default is FALSE}
}
\description{
Function that computes the most likely position for each mutation based on the genotype
}
\keyword{Clonal}
\keyword{inference}

