% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/QuantumClone.R
\name{Probability.to.belong.to.clone}
\alias{Probability.to.belong.to.clone}
\title{Probability}
\usage{
Probability.to.belong.to.clone(SNV_list, clone_prevalence, contamination,
  clone_weights = NULL)
}
\arguments{
\item{SNV_list}{A list of dataframes (one for each sample), with as columns : (for the first column of the first sample the name of the sample),
the chromosome "Chr",the position of the mutation "Start", the number of reads supporting the mutation "Alt", the depth of coverage at this locus "Depth",
and if the output from FREEC for the samples are not associated, the genotype "Genotype".}

\item{clone_prevalence}{List of numeric vectors giving the cellular prevalence of each clone in each sample}

\item{contamination}{Numeric vector giving the contamination by normal cells}

\item{clone_weights}{Numeric vector giving the proportion of mutations in each clone}
}
\description{
Returns dataframe with all informations about mutation (Number of copies, Cellularity, etc.) and probability to belong to a clone
}
\examples{
set.seed(123)
SNVs<-QuantumCat(number_of_clones = 2,number_of_mutations = 50,number_of_samples = 1)
Probability.to.belong.to.clone(SNV_list=SNVs,
clone_prevalence=list(c(0.5,1),c(0.5,1)),contamination=c(0,0))
}
\keyword{Clonal}
\keyword{inference}
\keyword{phylogeny}

