% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reAssign.R
\name{reAssign}
\alias{reAssign}
\alias{reAssign.tkmeans}
\title{Re-Assign Observations Trimmed Prior to Trimmed \eqn{k}-Means Clustering}
\usage{
reAssign(x, ...)

\method{reAssign}{tkmeans}(x, ...)
}
\arguments{
\item{x}{a \link[tclust]{tkmeans} object}

\item{...}{potential parameters, currently not in use.}
}
\value{
Function \link{reAssign.tkmeans} returns an \code{'reAssign_tkmeans'} object,
which inherits from \link[tclust]{tkmeans} class.
}
\description{
Re-assign the observations,
which are trimmed in the trimmed \eqn{k}-means algorithm,
back to the closest cluster as determined by the smallest
Mahalanobis distance.
}
\details{
Given the \link[tclust]{tkmeans} input,
the \link[stats]{mahalanobis} distance is computed between each trimmed observation
and each cluster.
Each trimmed observation is assigned to the closest cluster (i.e., with the smallest Mahalanobis distance).
}
\note{
Either \link[stats]{kmeans} or \link[tclust]{tkmeans} is slow for big \code{x}.
}
\examples{
library(tclust)
data(geyser2)
clus = tkmeans(geyser2, k = 3L, alpha = .03)
plot(clus, main = 'Before Re-Assigning')
plot(reAssign(clus), main = 'After Re-Assigning')

}
