% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/QLMDe.R
\name{S3_fmx_QLMDe}
\alias{S3_fmx_QLMDe}
\alias{vcov.fmx_QLMDe}
\alias{coef.fmx}
\alias{confint.fmx_QLMDe}
\alias{logLik.fmx}
\alias{nobs.fmx_QLMDe}
\title{Inference for Quantile Least Mahalanobis Distance estimates}
\usage{
\method{vcov}{fmx_QLMDe}(object, internal = FALSE, ...)

\method{coef}{fmx}(object, internal = FALSE, ...)

\method{confint}{fmx_QLMDe}(object, ..., level = 0.95)

\method{logLik}{fmx}(object, data = object@data, ...)

\method{nobs}{fmx_QLMDe}(object, ...)
}
\arguments{
\item{object}{an \linkS4class{fmx} or \linkS4class{fmx_QLMDe} object}

\item{internal}{\link[base]{logical} scalar, either for the user-friendly parameters (\code{FALSE}, default)
(e.g., \code{mean,sd} for normal mixture, and \code{A,B,g,h} for Tukey's \eqn{g}-and-\eqn{h} mixture), or
for the internal/unconstrained parameters (\code{TRUE}).}

\item{...}{place holder for S3 naming convention}

\item{level}{confidence level, default \eqn{95\%}.}

\item{data}{\link[base]{double} vector, actual observations}
}
\value{
\link{nobs.fmx_QLMDe} returns an \link[base]{integer} scalar indicating the sample size of
the observations used in \link{QLMDe} estimation. 

\link{logLik.fmx} returns a \link[stats]{logLik} object indicating the log-likelihood.
An additional attribute \code{attr(, 'logl')} indicates the point-wise log-likelihood, 
to be use in Vuong's closeness test.

\link{coef.fmx} returns the estimates of the user-friendly parameters (\code{parm = 'user'}), 
or the internal/unconstrained parameters (\code{parm = 'internal'}).

\link{vcov.fmx_QLMDe} returns 
the approximate asymptotic variance-covariance matrix of the user-friendly parameters via delta-method (\code{parm = 'user'}), 
or the asymptotic variance-covariance matrix of the internal/unconstrained parameters (\code{parm = 'internal'}). 

\link{confint.fmx_QLMDe} returns the Wald-type confidence intervals based on the user-friendly parameters (\code{parm = 'user'}),
 or the internal/unconstrained parameters (\code{parm = 'internal'}).

When the distribution has constraints on one or more parameters, none of \code{\link{coef.fmx}}, \link{vcov.fmx_QLMDe} and 
\link{confint.fmx_QLMDe} return the corresponding values only for the constrained parameters.
}
\description{
Additional methods of class \linkS4class{fmx} and/or \linkS4class{fmx_QLMDe},
for generic functions defined in \pkg{stats} package.
}
\details{
The inference for the user-friendly parameters is obtained via delta-method.
}
\seealso{
\link[stats]{nobs} \link[stats]{logLik} \link[stats]{coef} \link[stats]{vcov}
\link[stats]{confint}
}
