% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/QLMDinit.R
\name{QLMDinit}
\alias{QLMDinit}
\alias{QLMDinit_letterValue}
\alias{QLMDinit_normix}
\title{Initial Values for Quantile Least Mahalanobis Distance (QLMD) Estimates}
\usage{
QLMDinit_letterValue(x, K, constraint = character(), alpha = 0.05, ...)

QLMDinit_normix(x, K, alpha = 0.05, R = 10L, ...)

QLMDinit(x, distname = c("GH", "norm"), test = c("logLik", "CvM", "KS"), ...)
}
\arguments{
\item{x}{\link[base]{numeric} vector, the actual observations}

\item{K}{\link[base]{integer} scalar, number of mixture components}

\item{constraint}{\link[base]{character} vector, 
parameters (\eqn{g} and/or \eqn{h} for Tukey's \eqn{g}-&-\eqn{h} mixture) to be set at 0.  
See \link{fmx_constraint} for details.}

\item{alpha}{\link[base]{numeric} scalar, proportion of observations to be trimmed by 
trimmed k-means algorithm \link[tclust]{tkmeans}}

\item{...}{additional arguments}

\item{R}{\link[base]{integer} scalar, number of \link[mixtools]{normalmixEM} replicates}

\item{distname}{\link[base]{character} scalar, name of parametric distribution}

\item{test}{\link[base]{character} scalar, criteria for selecting the optimal estimates.
See \strong{Details}.}
}
\value{
\code{\link{QLMDinit_letterValue}}, \link{QLMDinit_normix} and \link{QLMDinit}
all return \linkS4class{fmx} objects.
}
\description{
Various methods for obtaining the initial values for 
Quantile Least Mahalanobis Distance (QLMD)
estimates of finite mixture distribution \linkS4class{fmx}.
}
\details{
First of all, if the specified number of components \eqn{K\geq 2},  
trimmed \eqn{k}-means clustering with re-assignment will be performed;
otherwise, all observations will be considered as one single cluster.
The standard \eqn{k}-means clustering is not used since the heavy tails of 
Tukey's \eqn{g}-&-\eqn{h} distribution could be mistakenly classified as individual cluster(s).
In each of the one or more clusters,

\itemize{

\item{The letter-value based estimates of Tukey's \eqn{g}-&-\eqn{h} distribution (Hoaglin, 2006)
are calculated, for any \eqn{K\geq 1}, serving as the starting values for 
QLMD algorithm.   
These estimates are provided by \code{\link{QLMDinit_letterValue}}.}

\item{the \link[stats]{median} and \link[stats:mad]{MAD} will serve as 
the starting values for \eqn{\mu} and \eqn{\sigma} 
(or \eqn{A} and \eqn{B} for Tukey's \eqn{g}-&-\eqn{h} distribution, with \eqn{g = h = 0}),
for QLMD algorithm
when \eqn{K = 1}.
Otherwise, the cluster centers are provided as the starting values of \eqn{\mu}'s for 
the univariate normal mixture by EM \link[mixtools:normalmixEM]{algorithm}.
\code{R} replicates of normal mixture estimates are obtained, and 
the one with maximum likelihood will serve as the starting values for 
QLMD algorithm.
These estimates are provided by \code{\link{QLMDinit_normix}}.}

}

\code{\link{QLMDinit}} compares 
the Tukey's \eqn{g}-&-\eqn{h} mixture estimate provided by \code{\link{QLMDinit_letterValue}}
and the normal mixture estimate by \code{\link{QLMDinit_normix}}, 
and select the one either with maximum likelihood (\code{test = 'logLik'}, default), 
with minimum Cramer-von Mises distance (\code{test = 'CvM'}) or 
with minimum Kolmogorov-Smirnov distance (\code{test = 'KS'}).
}
\examples{
d1 = fmx('norm', mean = c(1, 2), sd = .5, w = c(.4, .6))
set.seed(100); hist(x1 <- rfmx(n = 1e3L, dist = d1))
QLMDinit_normix(x1, distname = 'norm', K = 2L)

(d2 = fmx('GH', A = c(1,6), B = 2, g = c(0,.3), h = c(.2,0), w = c(1,2)))
set.seed(100); hist(x2 <- rfmx(n = 1e3L, dist = d2))
QLMDinit_letterValue(x2, K = 2L)
QLMDinit_letterValue(x2, K = 2L, constraint = c('g1', 'h2'))
QLMDinit_normix(x2, K = 2L)
QLMDinit(x2, distname = 'GH', K = 2L)

}
\seealso{
\link[stats]{kmeans} \link[tclust]{tkmeans} \link{reAssign} \link{letterValue} \link[mixtools]{normalmixEM}
}
