% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FRindex.R
\name{predict.FRindex}
\alias{predict.FRindex}
\title{Functional Regression Index Prediction}
\usage{
\method{predict}{FRindex}(
  object,
  newdata = object@X,
  new_xarg = as.numeric(colnames(newdata)),
  ...
)
}
\arguments{
\item{object}{an \linkS4class{FRindex} object}

\item{newdata}{\link[base]{matrix},
each row representing the tabulated, on a common grid,
functional predictor values for each subject.
The number of values in the grid of \code{newdata}
does not need to be the same as that number used to obtain \code{object}.
If the functional predictor is the \link[stats]{quantile} function,
then \code{newdata} is preferably the \link[base]{matrix} column of
the returned object of \link{clusterQp}.}

\item{new_xarg}{\link[base]{numeric} \link[base]{vector}, \eqn{x}-domain}

\item{...}{additional parameters, currently not in use}
}
\value{
\link{predict.FRindex} returns a \link[base]{numeric} \link[base]{vector},
which is the functional regression index of \code{newdata}.
}
\description{
Computes functional regression indices for new data using the \linkS4class{FRindex} object
}
\details{
Functional regression index for each subject in \code{newdata} is defined as
an integral of subject-specific functional predictor multiplied by the weight function common for all subjects.
The weight function \code{@FRwt} is obtained from \code{object@gam} using function \link{gam2beta}.
}
\examples{
# see ?`Qindex-package`

}
