% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BBC_dichotom.R
\name{BBC_dichotom}
\alias{BBC_dichotom}
\title{Bootstrap Bias Correction for Dichotomization}
\usage{
BBC_dichotom(formula, data, optQ, R, seed, ...)
}
\arguments{
\item{formula}{\link[stats]{formula}}

\item{data}{\link[base]{data.frame}}

\item{optQ}{\link[base]{character} scalar}

\item{R}{see \link[boot]{boot}}

\item{seed}{\link[base]{integer} scalar, random seeds for generating repeated samples, see \link[base]{set.seed}}

\item{...}{..}
}
\value{
..
}
\description{
Bootstrap-based optimism correction for dichotomizing quantiles
}
\details{
The bootstrap optimism correction procedure (1)
is performed as described for a general model selection in (2).
First, \code{R} bootstrap samples are drawn with replacement from the main sample.
In each bootstrap sample, the recursive partitioning tree model is used
to establish an objective data-driven optimal cut-point for a specific optimal quantile.
The cut-point from the current bootstrap sample is used to compute the log odds-ratio (OR) and/or hazards ratio (HR) for
dichotomized quantile predictor in the current bootstrap sample (\strong{bootstrap performance})
and in the main sample (\strong{test performance}),
and the optimism in log OR/HR estimation is computed as the difference between
log OR/HR for “Bootstrap performance” and for “Test performance”.
The median optimism estimate is computed as the median of optimism estimates over all bootstrap samples.
The cutpoint for dichotomizing each selected optimal quantile is also established in the
main sample and its “apparent performance” is computed as the log OR/HR for
dichotomized quantile in the univariate logistic regression or Cox models.
Finally, the optimism-corrected performance estimate is computed by subtracting the mean
optimism estimate from the apparent performance estimate.
}
\examples{

\donttest{
Ki67_Qps = sampleQp(data = Ki67, endpoint = 'RECURRENCE', subjID = 'PATIENT_ID', 
  Qpredictor = 'Marker', probs = seq(from = .05, to = .95, by = .05))
sapply(Ki67_Qps, FUN = class)   
head(Ki67_Qps$Marker)
(Ki67_eval = evalQp(RECURRENCE ~ Marker, data = Ki67_Qps, seeds = 1:100))
lapply(Ki67_eval, FUN = dim)
summary(Ki67_eval)
Ki67_opt = optQp(Ki67_eval, n = 2L)
colnames(Ki67_opt$Marker) = paste0('Ki67_', colnames(Ki67_opt$Marker))
    
PR_Qps = sampleQp(data = PR, endpoint = 'RECURRENCE', subjID = 'PATIENT_ID', 
  Qpredictor = 'Marker', probs = seq(from = .05, to = .95, by = .05))
head(PR_Qps$Marker)
PR_eval = evalQp(RECURRENCE ~ Marker, data = PR_Qps, seeds = 1:100)
PR_opt = optQp(PR_eval, n = 3L)
colnames(PR_opt$Marker) = paste0('PR_', colnames(PR_opt$Marker))

cellOpt0 = merge(Ki67_opt, PR_opt, by = setdiff(names(Ki67_opt), 'Marker'),
  suffixes = c('.Ki67', '.PR'))
cellOpt = within(cellOpt0, expr = {
  Marker = cbind(Marker.Ki67, Marker.PR)
  Marker.Ki67 = Marker.PR = NULL
})
dim(cellOpt)
names(cellOpt)
head(cellOpt$Marker)

mod = BBC_dichotom(RECURRENCE ~ NodeSt + Tstage, data = cellOpt, 
  optQ = 'Marker', R = 100, seed = 1)
names(mod)
mod$ucox_dictom
mod$mcox_dictom
mod$median.optimism
}  

}
