% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Qhot.R
\name{Qhot}
\alias{Qhot}
\title{QTL Hotspot}
\usage{
Qhot(DataQTL, DataCrop, ScanStep = 1, NH = 100, NP = 1000, save.pdf = TRUE)
}
\arguments{
\item{DataQTL}{data.frame. A data frame with 5 columns for QTL
information. The first three columns denote the serial number of
QTLs, trait names, and the chromosome numbers. The 4th and 5th denote
the flanking marker positions(cM) of QTLs.}

\item{DataCrop}{data.frame. A data frame with 3 columns for chromosome
information consists of the names, center positions(cM) and lengths
of chromosomes.}

\item{ScanStep}{numeric. A value for the length(cM) of every bin.}

\item{NH}{integer. A value for the number of spurious hotspots in the
proposed method.}

\item{NP}{integer. A value for permutation times to calculate the
threshold.}

\item{save.pdf}{logical. A logical variable, if save.pdf is set to be
TRUE, the pdf file of plots will be saved in the working directory
instead of being shown in the console.}
}
\value{
\item{EQF}{The expected QTL frequency(EQF) in every bin per chromosome.}
\item{P.threshold}{The EQF thresholds for proposed method.}
\item{Q.threshold}{The EQF thresholds for the Q method.}
\item{nHot}{The numbers of detected hotspots per chromosome for the proposed
method and Q method.}

Graphical outputs for visualizing the summarized results includes the
expected QTL frequency of scan steps, and the composition of QTLs for
different traits in the detected hotspots.
}
\description{
This function produces both the numerical and graphical summaries of
the QTL hotspot detection in the genomes that are available on the
web including the flanking markers of QTLs.
}
\note{
This program may generate a large amount of graphic output. It is
recommended to save the result in PDF file by the argument "save.pdf".
}
\examples{
# load the example data
load(system.file("extdata", "QHOTexample.RDATA", package = "QTLEMM"))

# run and result
result <- Qhot(QTL.example, crop.example, 5, 20, 100, save.pdf = FALSE)
}
\references{
Wu, P.-Y., M.-.H. Yang, and C.-H. KAO 2021 A Statistical Framework
for QTL Hotspot Detection. G3: Genes, Genomes, Genetics: jkab056.
}
