% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rdq.R
\name{rdq}
\alias{rdq}
\title{Estimate the QTE under the RDD}
\usage{
rdq(y, x, d, x0, z0 = NULL, tau, h.tau, cov)
}
\arguments{
\item{y}{a numeric vector, the outcome variable.}

\item{x}{a vector (or a matrix) of covariates, the first column is the running variable.}

\item{d}{a numeric vector, the treatment status.}

\item{x0}{the cutoff point.}

\item{z0}{the value of the covariates at which to evaluate the effects.
For example, if a female dummy is included, z0 = 1 may indicate the female subgroup.}

\item{tau}{a vector of quantiles of interest.}

\item{h.tau}{the bandwidth values (specified for each quantile level).}

\item{cov}{either 0 or 1. Set \emph{cov=1} if covariates are present in the model;
otherwise set \emph{cov=0}.}
}
\value{
A list with elements:
\describe{
\item{qte}{QTE estimates.}
\item{qp.est}{conditional quantile estimates on the right side of \eqn{x_{0}} (or for the D=1 group).}
\item{qm.est}{conditional quantile estimates on the left side of \eqn{x_{0}} (or for the D=0 group).}
\item{bcoe.p}{quantile regression coefficients on the right side of \eqn{x_{0}}.}
\item{bcoe.m}{quantile regression coefficients on the left side of \eqn{x_{0}}.}
}
}
\description{
\code{rdq} estimates QTE under the RDD with or without covariates. This function is used by \code{rd.qte} to generate QTE estimates.
}
\examples{
# Without covariate
n = 500
x = runif(n,min=-4,max=4)
d = (x > 0)
y = x + 0.3*(x^2) - 0.1*(x^3) + 1.5*d + rnorm(n)
tlevel = seq(0.1,0.9,by=0.1)
hh = rep(2,length(tlevel))
rdq(y=y,x=x,d=d,x0=0,z0=NULL,tau=tlevel,h.tau=hh,cov=0)

# (continued) With covariates
z = sample(c(0,1),n,replace=TRUE)
y = x + 0.3*(x^2) - 0.1*(x^3) + 1.5*d + d*z + rnorm(n)
rdq(y=y,x=cbind(x,z),d=d,x0=0,z0=c(0,1),tau=tlevel,h.tau=hh,cov=1)

}
