#' @keywords external
#' @author
#' * Zhongjun Qu <qu@bu.edu>
#' * Jungmo Yoon <jmyoon@hanyang.ac.kr>
"_PACKAGE"
#' @name QTE.RD-package
#' @details
#' The package \code{QTE.RD} includes four main functions:
#' * \code{rd.qte} estimates QTEs and provides uniform confidence bands, with or without covariates,
#' and with or without robust bias correction.
#' * \code{rdq.test} conducts tests for three hypotheses, related to the significance of
#' treatment effects, homogeneous treatment effects, and uniformly positive or negative treatment effects.
#' * \code{rdq.bandwidth} implements two bandwidth selection rules:
#' the cross-validation bandwidth and the MSE optimal bandwidth.
#' * \code{plot.qte} generates figures summarizing the treatment effects along with their confidence bands.
#'
#'
#' @references Zhongjun Qu, Jungmo Yoon, Pierre Perron (2024), "Inference on Conditional Quantile
#' Processes in Partially Linear Models with Applications to the Impact of Unemployment Benefits,"
#' The Review of Economics and Statistics; https://doi.org/10.1162/rest_a_01168
#' @references Zhongjun Qu and Jungmo Yoon (2019), "Uniform Inference on Quantile Effects
#' under Sharp Regression Discontinuity Designs," Journal of Business and Economic Statistics,
#' 37(4), 625–647; https://doi.org/10.1080/07350015.2017.1407323
#'
## usethis namespace: start
## usethis namespace: end
NULL
