% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sq.test.lvsl_1.R
\name{sq.test.lvsl_1}
\alias{sq.test.lvsl_1}
\title{Sequential Test for an Additional Break in a Conditional Quantile}
\usage{
sq.test.lvsl_1(y, x, v.tau, n.size = 1, vec.date)
}
\arguments{
\item{y}{A numeric vector of dependent variables (\eqn{NT \times 1}).}

\item{x}{A numeric matrix of regressors (\eqn{NT \times p}).}

\item{v.tau}{A numeric value representing the quantile of interest.}

\item{n.size}{An integer specifying the size of the cross-section (\eqn{N}).}

\item{vec.date}{A numeric vector of break dates estimated under the null hypothesis.}
}
\value{
A numeric value representing the test statistic.
}
\description{
This function tests the null hypothesis of \eqn{L} breaks against the alternative hypothesis of \eqn{L+1} breaks
in a single conditional quantile.
}
\details{
The function sequentially tests for breaks by splitting the sample conditional on the
break dates under the null hypothesis. At each step, it applies \code{sq.test.0vs1()} to compare
the hypothesis of no additional break against one more break.
}
\examples{
## data
data(gdp)
y = gdp$gdp
x = gdp[,c("lag1", "lag2")]

## quantile
v.tau = 0.8

# cross-sectional size
n.size = 1

## break date
vec.date = 146

## sq-test: 1 vs 2
result = sq.test.lvsl_1(y, x, v.tau, n.size, vec.date)
print(result)


}
\references{
Qu, Z. (2008). Testing for Structural Change in Regression Quantiles.
\emph{Journal of Econometrics}, 146(1), 170-184.

Oka, T. and Z. Qu (2011). Estimating Structural Changes in Regression Quantiles.
\emph{Journal of Econometrics}, 162(2), 248-267.
}
