% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ci.date.m.R
\name{ci.date.m}
\alias{ci.date.m}
\title{Confidence Intervals for Break Dates}
\usage{
ci.date.m(y, x, vec.tau, vec.date, n.size = 1, v.b = 2)
}
\arguments{
\item{y}{A numeric vector of dependent variables (\eqn{NT \times 1}).}

\item{x}{A numeric matrix of regressors (\eqn{NT \times p}).}

\item{vec.tau}{A numeric vector of quantiles of interest.}

\item{vec.date}{A numeric vector of estimated break dates.}

\item{n.size}{An integer specifying the size of the cross section (\eqn{N}).}

\item{v.b}{A numeric value specifying the confidence level:
\itemize{
\item \code{v.b = 1} for the 90\% confidence interval.
\item \code{v.b = 2} for the 95\% confidence interval.
}}
}
\value{
A numeric matrix where:
\itemize{
\item The 1st column contains the break dates.
\item The 2nd and 3rd columns contain the lower and upper bounds of the confidence intervals, respectively.
}
}
\description{
This function constructs confidence intervals for break dates
based on a single quantile or multiple quantiles (specified by the user).
}
\examples{

# data 
data(gdp)
y = gdp$gdp
x = gdp[,c("lag1", "lag2")] 

# quantiles 
vec.tau  = 0.8

# break dates (point estimates)
vec.date = c(146, 200)

# Calculate confidence intervals for break dates
res = ci.date.m(y, x, vec.tau, vec.date, n.size = 1, v.b = 2)
print(res)

}
\references{
Oka, T. and Z. Qu (2011).
Estimating Structural Changes in Regression Quantiles.
\emph{Journal of Econometrics}, 162(2), 248–267.
}
