% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cindex.R
\name{cindex}
\alias{cindex}
\title{Concordance index calculation}
\usage{
cindex(
  prob,
  fstatus,
  ftime,
  type = "crr",
  failcode = 1,
  cencode = 0,
  tol = 1e-20
)
}
\arguments{
\item{prob}{predicted risk of failure event, either probability or
risk score}

\item{fstatus}{failure(event) variable}

\item{ftime}{follow-up time variable for survival or competing risks
predictions}

\item{type}{type of regression models corresponding to different type
of outcomes.
'logis' is the default value for binary outcome, 'surv' for ordinary
survival outcome
and 'crr' for competing risks outcome.}

\item{failcode}{coding for failure(event). 1 is the default value.}

\item{cencode}{coding for censoring. 0 is the defaul}

\item{tol}{error tolerance. the default value is 1e-20.}
}
\value{
a vector of returned values.
\item{N}{the total number of observations in the input data}
\item{n}{the nonmissing number of observations that was used f
or calculation}
\item{usable}{the total number of usable pairs.}
\item{oncordant}{the number of concordant pairs}
\item{cindex}{the concordance index that equal to the number of
concordant pairs
divided by the total number of usable pairs.}
}
\description{
Calculate concordance index
}
\details{
to calculate the discrimination metric, concordance index for binary,
time-to event and competing risks outcomes
}
\examples{

\donttest{
data(prostate.dat)
dd <- datadist(prostate.dat)
options(datadist = "dd")
prostate.f <- cph(Surv(TIME_EVENT,EVENT_DOD == 1) ~ TX  + rcs(PSA,3) +
           BX_GLSN_CAT +  CLIN_STG + rcs(AGE,3) +
           RACE_AA, data = prostate.dat,
           x = TRUE, y= TRUE, surv=TRUE,time.inc = 144)
prostate.crr <- crr.fit(prostate.f,cencode = 0,failcode = 1)

## ten fold cross validation
prostate.dat$preds.tenf.cv.prostate.crr.120 <-
                                       tenf.crr(prostate.crr,time = 120)

## calculate the CRR version of concordance index
with(prostate.dat, cindex(preds.tenf.cv.prostate.crr.120 ,
                          ftime = TIME_EVENT,
                          fstatus =EVENT_DOD, type = "crr"))["cindex"]
}

}
\author{
Changhong Yu, Michael Kattan, Brian Wells, Amy Nowacki.
}
\keyword{regression}
\keyword{semiparametric}
