% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/xyplot.R
\name{plot.qca}
\alias{plot.qca}
\title{Plot the fuzzy set scores of the solution and the outcome against each other}
\usage{
\method{plot}{qca}(x, ...)
}
\arguments{
\item{x}{an object of class \code{qca} as returned by \code{\link{eqmcc}} of the package \code{QCA}}

\item{...}{further arguments passed on to \code{\link{xyplot}}}
}
\value{
the \code{ggplot} plot object
}
\description{
Plot the fuzzy set scores of the solution and the outcome against each other
}
\examples{
\dontrun{
require(QCAGUI)
data(d.urban)
solution <- eqmcc(d.urban, outcome="RT", conditions=c("MLC", "FRB", "CP", "WSR"))
plot(solution)
}
}

