% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/plot.fsQCApt.R
\name{plot.fsQCApt}
\alias{plot.fsQCApt}
\title{Plot Results of fsQCA Permutation Test}
\usage{
\method{plot}{fsQCApt}(x, y = x$config.names, statistic = "both", ...)
}
\arguments{
\item{x}{Object returned by \code{\link{fsQCApermTest}}.}

\item{y}{A vector of configurations to examine. Default behavior is
to examine all configurations.}

\item{statistic}{The statistic to examine (\code{consistency},
\code{counterexamples}, or \code{both}).}

\item{...}{Additional parameters to pass on.}
}
\value{
Plots of distributions of consistencies, counterexamples, or both.
}
\description{
Plots distributions of consistencies and counterexamples from permutation tests
of fsQCA data, including confidence intervals adjusted to account for multiple
inference. Also prints observed consistency values and number of counterexamples
as black dots along the x-axis, for comparison.
}
\examples{
data(social.revolutions)
attach(social.revolutions)

intersect <- pmin(breakdown, pop.ins)
intersect2 <- pmin(breakdown, (1-pop.ins))
intersect3 <- pmin((1-breakdown), pop.ins)
intersect4 <- pmin((1-breakdown), (1-pop.ins))

test <- fsQCApermTest(y=soc.rev, configs=list(BI=intersect, Bi=intersect2,
   bI=intersect3, bi=intersect4), total.configs=4)
plot(test)
plot(test, "bi", statistic="consistency")
plot(test, c("BI", "Bi"), statistic="both")
plot(test, statistic="consistency")
plot(test, "BI")
}
\keyword{distribution}
\keyword{fsQCA}
\keyword{permutation}
\keyword{test}

