% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/partition_min_inter.R
\name{partition_min_inter}
\alias{partition_min_inter}
\title{Generation of intermediate solutions for individual partitions of
clustered set-relational data}
\usage{
partition_min_inter(
  dataset,
  units,
  time,
  cond,
  out,
  n_cut,
  incl_cut,
  intermediate,
  BE_cons,
  WI_cons,
  BE_ncut,
  WI_ncut
)
}
\arguments{
\item{dataset}{Calibrated pooled dataset for partitioning and minimization}

\item{units}{Units defining the within-dimension of data (time series)}

\item{time}{Periods defining the between-dimension of data (cross sections)}

\item{cond}{Conditions used for the pooled analysis}

\item{out}{Outcome used for the pooled analysis}

\item{n_cut}{Frequency cut-off for designating truth table rows as observed}

\item{incl_cut}{Inclusion cut-off for designating truth table rows as
consistent}

\item{intermediate}{A vector of directional expectations to derive intermediate solutions}

\item{BE_cons}{Inclusion (or consistency) thresholds for cross sections.
Must be specified as a numeric vector with length equaling the number of
cross sections. Numbers correspond to the order of the cross section ID
in the data (such as years in ascending order).}

\item{WI_cons}{Inclusion (or consistency) thresholds for time series.
Must be specified as a numeric vector with length equaling the number of
time series. Numbers correspond to the order of the time series (unit) ID
in the data (such as countries in alphabetical order).}

\item{BE_ncut}{For \emph{cross sections}, the minimum number of members needed
for declaring a truth table row
as relevant as opposed to designating it as a remainder.
Must be specified as a numeric vector. Its length should be
equal the number of cross sections. The order of thresholds corresponds
to the order of the cross sections in the data defined by the cross-section
ID in the dataset (such as years in ascending order).}

\item{WI_ncut}{For \emph{time series}, the minimum number of members needed
for declaring a truth table row
as relevant as opposed to designating it as a remainder.
Must be specified as a numeric vector. Its length should be
equal the number of time series. The order of thresholds corresponds
to the order of the of the time-series (unit) ID
in the dataset (such as countries in alphabetical order).}
}
\value{
A dataframe summarizing the partition-specific and pooled solutions
with the following columns:
\itemize{
\item \code{type}: The type of the partition. \code{pooled} are rows with information
on the pooled data; \code{between} is for cross-section partitions;
\code{within} is for time-series partitions.
\item \code{partition}: Specific dimension of the partition at hand. For
between-dimension, the unit identifiers are included here  (argument \code{units}).
For the within-dimension, the time identifier are listed (argument \code{time}).
The entry is \code{-} for the pooled data without partitions.
\item \code{solution}: The solution derived for the partition or the pooled data.
Absence of a condition is denoted by the \code{~} sign.
\item \code{model}: Running ID for models. In the presence of model ambiguity, each
model has its own row with its individual solution and parameters. The rest of
the information in the row is duplicated, for example by having two rows for
the within-partition 1996. The column \code{model} highlights the presence of
model ambiguity by numbering all models belonging to the same solution. For
example, if three consecutive rows are numbered 1, 2 and 3, then these rows
belong to the same solution and represent model ambiguity. If a 1 in a row
is followed by another 1, then there is no model ambiguity.
\item \code{consistency}: The consistency score (a.k.a. inclusion score)
for the partition of the data or the pooled data.
\item \code{coverage}: The coverage score for the partition of the data
or the pooled data.
}
}
\description{
\code{partition_min_inter} decomposes clustered data into individual
partitions such as cross-sections and time-series for panel
data. It derives an individual intermediate solution for each partition
and the pooled data to assess the robustness of the
solutions.
}
\examples{
data(Schwarz2016)
Schwarz_inter <- partition_min_inter(
  Schwarz2016,
  units = "country", time = "year",
  cond = c("poltrans", "ecotrans", "reform", "conflict", "attention"),
  out = "enlarge",
  n_cut = 1, incl_cut = 0.8,
  intermediate = c("1", "1", "1", "1", "1"))

}
