% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qbms.R
\name{list_programs}
\alias{list_programs}
\title{Get the List of Breeding Programs Names}
\usage{
list_programs()
}
\value{
A list of breeding programs names.
}
\description{
Retrieves the breeding programs list from the current active crop as configured 
in the internal configuration object using `set_crop()` function.
}
\examples{
if(interactive()) {
  # Configure your server connection
  set_qbms_config("https://bms.icarda.org/ibpworkbench")

  # Login using your account (interactive mode)
  # You can pass your username and password as parameters (batch mode)
  login_bms()

  # Select a crop by name
  set_crop("wheat")

  # List existing breeding programs
  list_programs()
}

}
\seealso{
\code{\link{login_bms}}, \code{\link{set_crop}}
}
\author{
Khaled Al-Shamaa, \email{k.el-shamaa@cgiar.org}
}
