% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qbms.R
\name{login_gigwa}
\alias{login_gigwa}
\title{Login to the GIGWA server}
\usage{
login_gigwa(username = NULL, password = NULL)
}
\arguments{
\item{username}{the GIGWA username (optional, default is NULL)}

\item{password}{the GIGWA password (optional, default is NULL)}
}
\value{
no return value
}
\description{
Connect to the GIGWA server. If username or password parameters are missing,
then a login window will pop-up to insert username and password.

All other connection parameters (i.e. server IP or domain, connection port,
API path, and connection protocol e.g. http://) will retrieve from the
qbms_config list.

This function will update both of the qbms_config list (brapi connection
object in the con key) and qbms_state list (token value in the token key).
}
\examples{
if(interactive()) {
# config your GIGWA connection
set_qbms_config("http://localhost:59395/gigwa/index.jsp", time_out = 300, engine = "gigwa")

# login using your GIGWA account (interactive mode)
# you can pass GIGWA username and password as parameters (batch mode)
login_gigwa()
login_gigwa("gigwadmin", "nimda")
}
}
\author{
Khaled Al-Shamaa, \email{k.el-shamaa@cgiar.org}
}
