% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qbms.R
\name{set_trial}
\alias{set_trial}
\title{Set the current active trial}
\usage{
set_trial(trial_name)
}
\arguments{
\item{trial_name}{the name of the trial}
}
\value{
no return value
}
\description{
This function will update the current active trial in the internal state 
object using the trialDbId retrieved from BMS which is associated to the 
given trial_name parameter.
}
\examples{
if(interactive()){
# config your BMS connection
set_qbms_config("https://www.bms-uat-test.net/ibpworkbench")

# login using your BMS account (interactive mode)
# you can pass BMS username and password as parameters (batch mode)
login_bms()

set_crop("maize")

# select a breeding program by name
set_program("MC Maize")

# select a specific study/trial by name
set_trial("2018 PVT")
}
}
\seealso{
\code{\link{login_bms}}, \code{\link{set_crop}}, \code{\link{set_program}}, \code{\link{list_trials}}
}
\author{
Khaled Al-Shamaa, \email{k.el-shamaa@cgiar.org}
}
