% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load.project.R
\name{load.project}
\alias{load.project}
\title{Automatically load data and packages for a project.}
\usage{
load.project(...)
}
\arguments{
\item{...}{Named arguments to override configuration from \code{config/global.dcf}
and \code{lib/global.R}.}
}
\value{
No value is returned; this function is called for its side effects.
}
\description{
This function automatically load all of the data and packages used by
the project from which it is called.  The behaviour can be controlled by
adjusting the \code{\link{project.config}} configuration.
}
\details{
\code{...} can take an argument override.config or a single named
  list for backward compatibility. This cannot be mixed with the new style
  override. When a named argument override.config is present it takes
  precedence over the other options. If any of the provided arguments is
  unnamed an error is raised.
}
\examples{
library('ProjectTemplate')

\dontrun{load.project()}
}
\seealso{
\code{\link{create.project}}, \code{\link{get.project}},
  \code{\link{cache.project}}, \code{\link{show.project}}, \code{\link{project.config}}
}
