% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/queryDB.R
\name{queryDB}
\alias{queryDB}
\title{A function to query the database}
\usage{
queryDB(queryItem)
}
\arguments{
\item{queryItem}{a character string providing the query}
}
\description{
A queryDB function to perform self-defined queries on the PROFOUND database.
}
\note{
To report errors in the package or the data, please use the issue tracker
in the GitHub repository of ProfoundData \url{https://github.com/COST-FP1304-PROFOUND/ProfoundData}
}
\examples{
# example requires that a sql DB is registered via setDB(dbfile)
# when run without a registered DB, you will get a file query (depending on OS)

\dontrun{
# Basic query
overview <- queryDB("SELECT * FROM OVERVIEW")
tree <- queryDB("SELECT * FROM TREE")

# Site name or site_id
myQuery <- queryDB("SELECT date, tmax_degC FROM CLIMATE_LOCAL WHERE site == 'hyytiala'")
myQuery <- queryDB("SELECT date, tmax_degC FROM CLIMATE_LOCAL_12")

# Tree species
myQuery <- queryDB("SELECT  * FROM TREE WHERE species == 'Picea abies'")
myQuery <- queryDB("SELECT  * FROM TREE_piab")

# Specify variables
myQuery <- queryDB("SELECT date, tmax_degC FROM CLIMATE_LOCAL WHERE
                   tmax_degC > 20 AND site == 'hyytiala' AND year == 2010")
}
}
