% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/01supporting_functions.r
\name{signedIntToRaw}
\alias{signedIntToRaw}
\title{Convert signed integers (short) into a raw vector}
\usage{
signedIntToRaw(int_dat)
}
\arguments{
\item{int_dat}{A vector of integer values, ranging from -128 up to 127.}
}
\value{
A vector of the same length as \code{int_dat}, holding \code{raw} data.
}
\description{
This function converts signed integer values into a vector of \code{raw} data.
}
\details{
This function converts signed integer values [-128,127] into a vector of
\code{raw} data. The function
will fail on values that are out of range (< -128 or > 127). To convert
raw data into a vector of unsigned integers use \code{\link{as.integer}(x)}.
For the inverse of this function see \code{\link{rawToSignedInt}(raw_dat)}.
}
\examples{
## generate some signed integers:
some.integers <- c(-100, 40, 0, 30, -123)

## convert the signed integers into a vector of raw data:
signedIntToRaw(some.integers)

}
\seealso{
Other raw.operations: 
\code{\link{as.raw}()},
\code{\link{nybbleToSignedInt}()},
\code{\link{nybble}()},
\code{\link{rawToCharNull}()},
\code{\link{rawToPTModule}()},
\code{\link{rawToSignedInt}()},
\code{\link{rawToUnsignedInt}()},
\code{\link{signedIntToNybble}()},
\code{\link{unsignedIntToRaw}()}

Other integer.operations: 
\code{\link{nybbleToSignedInt}()},
\code{\link{nybble}()},
\code{\link{rawToSignedInt}()},
\code{\link{rawToUnsignedInt}()},
\code{\link{signedIntToNybble}()},
\code{\link{unsignedIntToRaw}()},
\code{\link{waveform}()}
}
\author{
Pepijn de Vries
}
\concept{integer.operations}
\concept{raw.operations}
