% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/08coercion.r
\docType{methods}
\name{PTCell-method}
\alias{PTCell-method}
\alias{PTCell,raw,missing,missing,missing-method}
\alias{PTCell,character,missing,missing,missing-method}
\alias{PTCell,PTModule,numeric,numeric,numeric-method}
\alias{PTCell<-}
\alias{PTCell<-,PTModule,numeric,numeric,numeric,PTCell-method}
\alias{PTCell,PTPattern,numeric,numeric,missing-method}
\alias{PTCell<-,PTPattern,numeric,numeric,missing,PTCell-method}
\alias{PTCell,PTTrack,numeric,missing,missing-method}
\alias{PTCell<-,PTTrack,numeric,missing,missing,PTCell-method}
\alias{PTCell<-,PTTrack,numeric,missing,missing-method}
\title{Coerce to or replace PTCell}
\usage{
\S4method{PTCell}{raw,missing,missing,missing}(x)

\S4method{PTCell}{character,missing,missing,missing}(x)

\S4method{PTCell}{PTModule,numeric,numeric,numeric}(x, row, track, pattern)

\S4method{PTCell}{PTModule,numeric,numeric,numeric,PTCell}(x, row, track,
  pattern) <- value

\S4method{PTCell}{PTPattern,numeric,numeric,missing}(x, row, track)

\S4method{PTCell}{PTPattern,numeric,numeric,missing,PTCell}(x, row,
  track) <- value

\S4method{PTCell}{PTTrack,numeric,missing,missing}(x, row)

\S4method{PTCell}{PTTrack,numeric,missing,missing,PTCell}(x, row) <- value
}
\arguments{
\item{x}{Object (any of \code{raw} data, a \code{character} string, a \code{PTTrack},
a \code{PTPattern} or a \code{PTModule})
to coerce to a \code{\link{PTCell}}. See details below for the
required format of \code{x}.}

\item{row}{When \code{x} is a \code{PTTrack}, a \code{PTPattern},
or a \code{PTModule}, provide an index [1,64] of the row that needs
to be coerced to a \code{PTCell}.}

\item{track}{When \code{x} is a \code{PTPattern},
or a \code{PTModule}, provide an index [1,4] of the track that needs
to be coerced to a \code{PTCell}.}

\item{pattern}{When \code{x} is a \code{PTModule}, provide an index
of the pattern that needs to be coerced to a \code{PTCell}. Note that
ProTracker uses indices for patterns that start at zero, whereas R uses indices
that start at one. Hence add one to an index obtained from a \code{PTModule}
object (e.g., \code{x$pattern.order})}

\item{value}{An object of \code{\link{PTCell}} with which the \code{\link{PTCell}}
object at the specified indices in object \code{x} needs to be replaced.}
}
\value{
When \code{PTCell} is used, a \code{PTCell} object
based on \code{x} is returned.

When \code{PTCell<-} is used, object \code{x} is returned in which
the selected \code{PTCell} is replaced with \code{value}.
}
\description{
This method will coerce a set of objects to a \code{PTCell} object. It can also
be used to select specific cells from \code{PTModule},
\code{PTPattern} and \code{PTTrack} objects and replace
the selected \code{PTCell}.
}
\details{
Method to coerce \code{x} to class \code{\link{PTCell}}.

When \code{x} is \code{raw} data, it should consist of a \code{vector} of
4 elements, formatted as specified in the \link{PTCell-class}.

When \code{x} is a \code{character} string, it should be formatted as follows:
"\code{NNO SS EEE}", where \code{NN} is the note (for instance
"C-" or "A#", where the dash has no particular meaning and may be omitted,
the hash sign indicates a sharp note). Use a dash if the cell holds no note.
\code{O} is the octave (with a value of 0, or a dash, if a note
is missing, otherwise any of 1, 2 or 3). \code{SS} is the sample index
number, formatted as two hexadecimal digits (for example `1A'). \code{EEE} is
a three hexadecimal digit \code{\link{effect}} or trigger code (for more details see the
\code{\link{PTCell-class}}). The method is not case sensitive, so
you can use both upper and lower case. White spaces are ignored, you can use
as many as you would like. A correct \code{character} input for \code{x}
would be for example: "\code{A#2 01 A0F}". An `blank' \code{character}
representation would look like this: "\code{--- 00 000}".

When \code{x} is of class \code{\link{PTTrack}}, \code{\link{PTPattern}}, or
\code{\link{PTModule}}, the \code{PTCell} at the specified indices (\code{row},
\code{track} and \code{pattern}) is returned, or can be replaced.
}
\examples{
## This will create an empty PTCell (equivalent
## to new("PTCell"):
PTCell(raw(4))

## Use a character representation to create
## a new PTCell object. A cell with note
## B in octave 2, sample number 10 and with
## effect '105':
cell <- PTCell("B-2 0A 105")

data("mod.intro")

## replace PTCell at pattern number 1, track
## number 2, and row number 3:
PTCell(mod.intro, 3, 2, 1) <- cell

}
\seealso{
Other cell.operations: \code{\link{PTCell-class}},
  \code{\link{effect}}, \code{\link{note}},
  \code{\link{sampleNumber}}
}
\author{
Pepijn de Vries
}
