% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/05PTSample.r
\name{resample}
\alias{resample}
\title{Resample data}
\usage{
resample(x, source.rate, target.rate, ...)
}
\arguments{
\item{x}{A \code{numeric} \code{vector} that needs to be resampled.}

\item{source.rate}{The rate at which \code{x} was sampled in Hz (or
another unit, as long as it is in the same unit as \code{target.rate}).}

\item{target.rate}{The desired target sampling rate in Hz (or
another unit, as long as it is in the same unit as \code{source.rate}).}

\item{...}{Arguments passed on to \code{\link[stats]{approx}}.
To simulate the Commodore Amiga hardware, it's best to
use '\code{method = "constant"} for resampling 8 bit samples.}
}
\value{
Returns a resampled \code{numeric} \code{vector} of length
\code{round(length(x) * target.rate / source.rate)} based on \code{x}.
}
\description{
Resample \code{numeric} data to a different rate.
}
\details{
This function resamples \code{numeric} data (i.e., audio data) from a
source sample rate to a target sample rate. At the core it uses
the \code{\link[stats]{approx}} function.
}
\examples{
some.data <- 1:100

## assume that the current (sample) rate
## of 'some.data' is 100, and we want to
## resample this data to a rate of 200:
resamp.data <- resample(some.data, 100, 200, method = "constant")
}
\author{
Pepijn de Vries
}

