% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/05PTSample.r
\docType{methods}
\name{read.sample}
\alias{read.sample}
\alias{read.sample,character-method}
\title{Read an audio file and coerce to a PTSample object}
\usage{
\S4method{read.sample}{character}(filename, what = c("wav", "mp3", "8svx",
  "raw"))
}
\arguments{
\item{filename}{A \code{character} string representing the filename to be read.}

\item{what}{A \code{character} string indicating what type of file is to be
read. Can be one of the following: "\code{wav}" (default), "\code{mp3}",
"\code{8svx}" or "\code{raw}".}
}
\value{
Returns a \code{PTSample} object based on the file read.
}
\description{
Reads audio files from "wav" and "mp3" files, using \code{\link[tuneR]{tuneR}}
methods. Commodore Amiga native formats "8svx" and "raw" can also be read.
}
\details{
This method provides a wrapper for the \code{\link[tuneR]{readWave}} and
\code{\link[tuneR]{readMP3}} methods from \code{\link[tuneR]{tuneR}}. It also
provides the means to import audio from file formats native to the Commodore
Amiga. Simple \href{https://en.wikipedia.org/wiki/8SVX}{8svx} files (also known
as "iff" files) can be read, it has not yet been tested with more complex 8svx files.
It was also common practice to store audio samples as raw data on the
Commodore Amiga, where each byte simply represented a signed integer value
of the waveform.

All audio will be coerced to 8 bit mono with a maximum length of
\code{2*0xffff} = {131070} bytes (= samples) as per ProTracker standards.
}
\note{
As per ProTracker standards, a sample should have an even length
(in bytes). If a sample file has an odd length, a \code{raw} \code{0x00} value
is added to the end.
}
\examples{
\dontrun{
data("mod.intro")

## create an audio file which we can then read:
write.sample(PTSample(mod.intro, 2), "snaredrum.iff", "8svx")

## read the created sample:
snare <- read.sample("snaredrum.iff", "8svx")
print(snare)
}
}
\author{
Pepijn de Vries
}
\seealso{
Other io.operations: \code{\link{read.module}},
  \code{\link{read.module,ANY-method}},
  \code{\link{read.module,character-method}};
  \code{\link{write.module}},
  \code{\link{write.module,PTModule,ANY-method}},
  \code{\link{write.module,PTModule,character-method}};
  \code{\link{write.sample}},
  \code{\link{write.sample,PTSample,character-method}}

Other sample.operations: \code{\link{PTSample,PTModule,numeric-method}},
  \code{\link{PTSample,Wave,missing-method}},
  \code{\link{PTSample,raw,missing-method}},
  \code{\link{PTSample-method}}, \code{\link{PTSample<-}},
  \code{\link{PTSample<-,PTModule,numeric,PTSample-method}};
  \code{\link{PTSample}}, \code{\link{PTSample-class}};
  \code{\link{fineTune}},
  \code{\link{fineTune,PTSample-method}},
  \code{\link{fineTune<-}},
  \code{\link{fineTune<-,PTSample,numeric-method}};
  \code{\link{loopLength}},
  \code{\link{loopLength,PTSample-method}},
  \code{\link{loopLength<-}},
  \code{\link{loopLength<-,PTSample-method}};
  \code{\link{loopSample}},
  \code{\link{loopSample,PTSample-method}};
  \code{\link{loopStart}},
  \code{\link{loopStart,PTSample-method}},
  \code{\link{loopStart<-}},
  \code{\link{loopStart<-,PTSample-method}};
  \code{\link{loopState}},
  \code{\link{loopState,PTSample-method}};
  \code{\link{name}}, \code{\link{name,PTModule-method}},
  \code{\link{name,PTSample-method}}, \code{\link{name<-}},
  \code{\link{name<-,PTModule,character-method}},
  \code{\link{name<-,PTSample,character-method}};
  \code{\link{playSample}},
  \code{\link{playSample,PTModule-method}},
  \code{\link{playSample,PTSample-method}};
  \code{\link{sampleLength}},
  \code{\link{sampleLength,PTSample-method}};
  \code{\link{volume}},
  \code{\link{volume,PTSample-method}},
  \code{\link{volume<-}},
  \code{\link{volume<-,PTSample,numeric-method}};
  \code{\link{waveform}},
  \code{\link{waveform,PTSample-method}},
  \code{\link{waveform<-}},
  \code{\link{waveform<-,PTSample-method}};
  \code{\link{write.sample}},
  \code{\link{write.sample,PTSample,character-method}}
}

