% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_independent_expenditure_support_candidate.R
\name{get_independent_expenditure_support_candidate}
\alias{get_independent_expenditure_support_candidate}
\title{Get Independent Expenditures that Support or Oppose a Specific Candidate}
\usage{
get_independent_expenditure_support_candidate(
  cycle = 2018,
  FEC_ID,
  page = 1,
  myAPI_Key
)
}
\arguments{
\item{cycle}{The election cycle}

\item{FEC_ID}{The FEC-assigned 9-character ID of a committee. To find a committee official FEC ID, use a candidate search request or the FEC web site.}

\item{page}{Results come in batches of 20. The page parameter specifies which one to retrieve.}

\item{myAPI_Key}{API key from Propublica To use the congress API, you must sign up for an API key.}
}
\value{
List of returned JSON from endpoint that retrieves the 200 most recent independent expenditures in support of or opposition to a given candidate.
}
\description{
#HTTP Request: GET https://api.propublica.org/campaign-finance/v1/{cycle}/candidates/{fec-id}/independent_expenditures
}
\examples{
\donttest{
get_independent_expenditure_support_candidate(2016, FEC_ID ='P00003392')
}
}
