% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_comparing_indices.R
\name{compare_to_target}
\alias{compare_to_target}
\title{Calculating distances between considered price indices and the target price index}
\usage{
compare_to_target(
  data = data.frame(),
  target,
  measure = "MAD",
  pp = TRUE,
  first = TRUE,
  prec = 3
)
}
\arguments{
\item{data}{A data frame containg values of indices which are to be compared to the target price index}

\item{target}{A data frame or a vector containg values of the target price index}

\item{measure}{A parameter specifying what measure should be used to compare indices. Possible parameter values are: "MAD" (Mean Absolute Distance) or "RMSD" (Root Mean Square Distance).}

\item{pp}{Logical parameter indicating whether the results are to be presented in percentage points (then \code{pp} = TRUE).}

\item{first}{A logical parameter that determines whether the first row of the data frame and the first row of the 'target' data frame (or its first element if it is a vector) are to be taken into account when calculating the distance between the indices (then \code{first} = TRUE). Usually, the first row concerns the index values for the base period - all indexes are then set to one.}

\item{prec}{Parameter that determines how many decimal places are to be used in the presentation of results.}
}
\value{
The function calculates average distances between considered price indices and the target price index and it returns a data frame with: average distances on the basis of all values of compared indices ('distance' column), average semi-distances on the basis of values of compared indices which overestimate the target index values ('distance_upper' column) and average semi-distances on the basis of values of compared indices which underestimate the target index values ('distance_lower' column).
}
\description{
The function calculates distances between considered price indices and the target price index
}
\examples{
#Creating a data frame with example bilateral indices
\donttest{df<-price_indices(milk, 
formula=c("jevons","laspeyres","paasche","walsh"),
start="2018-12",end="2019-12",interval=TRUE)}
#Calculating the target Fisher price index
\donttest{target_index<-fisher(milk,start="2018-12",end="2019-12",interval=TRUE)}
#Calculating average distances between considered indices and the Fisher index (in p.p)
\donttest{compare_to_target(df,target=target_index)}
}
