/*
 * Decompiled with CFR 0.152.
 */
package org.openfast.examples.util;

import java.io.IOException;
import java.io.InputStream;
import org.openfast.Context;
import org.openfast.Message;
import org.openfast.codec.FastDecoder;
import org.openfast.examples.util.FastMessageConsumer;
import org.openfast.template.TemplateRegistry;
import org.openfast.template.loader.XMLMessageTemplateLoader;

public class FastMessageReader {
    private final TemplateRegistry templateRegistry;
    private final InputStream messageIn;
    private final FastMessageConsumer messageOut;
    private final int readOffset;
    private int head;
    private boolean raw = false;
    private boolean reset = false;

    public FastMessageReader(InputStream input, InputStream templateStream, FastMessageConsumer output) {
        this(input, templateStream, output, 0);
    }

    public FastMessageReader(InputStream input, InputStream templateStream, FastMessageConsumer output, int readOffset) {
        this.readOffset = readOffset;
        this.messageIn = input;
        XMLMessageTemplateLoader templateLoader = new XMLMessageTemplateLoader();
        templateLoader.setLoadTemplateIdFromAuxId(true);
        templateLoader.load(templateStream);
        this.templateRegistry = templateLoader.getTemplateRegistry();
        this.messageOut = output;
    }

    public void start() {
        Context context = new Context();
        context.setTemplateRegistry(this.templateRegistry);
        FastDecoder decoder = new FastDecoder(context, this.messageIn);
        boolean more = true;
        int recordNumber = 0;
        if (this.head == 0) {
            this.head = Integer.MAX_VALUE;
        }
        while (more && ++recordNumber < this.head) {
            Message message;
            if (this.reset) {
                decoder.reset();
            }
            if (this.raw) {
                try {
                    this.messageIn.mark(20);
                    byte[] sor = new byte[20];
                    this.messageIn.read(sor, 0, 20);
                    StringBuffer b = new StringBuffer("Record# " + recordNumber);
                    int i = 0;
                    while (i < sor.length) {
                        byte aSor = sor[i];
                        b.append(Integer.toHexString(aSor));
                        ++i;
                    }
                    this.messageOut.annotate(b.toString());
                    this.messageIn.reset();
                }
                catch (IOException e) {
                    try {
                        this.messageIn.mark(20);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
            if ((message = decoder.readMessage(this.readOffset)) == null) {
                more = false;
                continue;
            }
            this.messageOut.accept(message);
        }
    }

    public void setHead(int count) {
        this.head = count;
    }

    public void showRawData(boolean flag) {
        this.raw = flag;
    }

    public void resetEveryRecord(boolean resetEveryRecord) {
        this.reset = resetEveryRecord;
    }
}

