/*
 * Decompiled with CFR 0.152.
 */
package org.openfast.examples.producer;

import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.io.xml.XppDriver;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.openfast.FieldValue;
import org.openfast.GroupValue;
import org.openfast.Message;
import org.openfast.QName;
import org.openfast.SequenceValue;
import org.openfast.template.BasicTemplateRegistry;
import org.openfast.template.Field;
import org.openfast.template.Group;
import org.openfast.template.MessageTemplate;
import org.openfast.template.Sequence;
import org.openfast.template.TemplateRegistry;

public class XmlCompressedMessageConverter {
    private static final QName INSTANCE_NAME = new QName("instanceName", "http://www.lasalletech.com/fast/ext/1.0");
    protected TemplateRegistry templateRegistry = new BasicTemplateRegistry();
    private final HierarchicalStreamDriver driver;

    public XmlCompressedMessageConverter() {
        this((HierarchicalStreamDriver)new XppDriver());
    }

    public XmlCompressedMessageConverter(HierarchicalStreamDriver driver) {
        if (driver == null) {
            throw new NullPointerException();
        }
        this.driver = driver;
    }

    public List parse(InputStream in) {
        HierarchicalStreamReader reader = this.driver.createReader(in);
        return this.unmarshal(reader);
    }

    public void serialize(List messages, OutputStream out) {
        HierarchicalStreamWriter writer = this.driver.createWriter(out);
        writer.startNode("messages");
        for (Message message : messages) {
            this.marshal(message, writer, null);
        }
        writer.endNode();
        writer.close();
    }

    public void marshal(Object obj, HierarchicalStreamWriter writer, MarshallingContext context) {
        Message message = (Message)obj;
        writer.startNode(message.getGroup().getName());
        this.writeGroup(writer, message);
        writer.endNode();
    }

    private void writeGroup(HierarchicalStreamWriter writer, GroupValue groupValue) {
        Field[] fields = groupValue.getGroup().getFields();
        int i = 0;
        while (i < fields.length) {
            Field field = fields[i];
            if (groupValue.isDefined(field.getName()) && !field.getName().equals("templateId")) {
                writer.startNode(field.getName());
                if (field instanceof Group) {
                    this.writeGroup(writer, groupValue.getGroup(field.getName()));
                } else if (field instanceof Sequence) {
                    String instanceName = field.getName();
                    if (field.hasAttribute(INSTANCE_NAME)) {
                        instanceName = field.getAttribute(INSTANCE_NAME);
                    }
                    SequenceValue sequenceValue = groupValue.getSequence(field.getName());
                    GroupValue[] seqValues = sequenceValue.getValues();
                    int j = 0;
                    while (j < seqValues.length) {
                        writer.startNode(instanceName);
                        this.writeGroup(writer, seqValues[j]);
                        writer.endNode();
                        ++j;
                    }
                } else {
                    writer.setValue(groupValue.getString(field.getName()));
                }
                writer.endNode();
            }
            ++i;
        }
    }

    public List unmarshal(HierarchicalStreamReader reader) {
        if (reader.getNodeName().equals("messages")) {
            ArrayList<Message> messages = new ArrayList<Message>();
            while (reader.hasMoreChildren()) {
                reader.moveDown();
                if (!this.templateRegistry.isRegistered(reader.getNodeName())) {
                    throw new IllegalArgumentException("The template named " + reader.getNodeName() + " is not defined.");
                }
                MessageTemplate template = this.templateRegistry.get(reader.getNodeName());
                Message message = (Message)template.createValue(null);
                this.parseGroup(reader, template, message);
                messages.add(message);
                reader.moveUp();
            }
            return messages;
        }
        return null;
    }

    private void parseGroup(HierarchicalStreamReader reader, Group group, GroupValue groupValue) {
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            Field field = group.getField(reader.getNodeName());
            if (field != null) {
                FieldValue value = null;
                if (field instanceof Group) {
                    Group currentGroup = (Group)field;
                    value = currentGroup.createValue(null);
                    this.parseGroup(reader, currentGroup, (GroupValue)value);
                } else if (field instanceof Sequence) {
                    Sequence currentSequence = (Sequence)field;
                    value = currentSequence.createValue(null);
                    this.parseSequence(reader, currentSequence, (SequenceValue)value);
                } else {
                    value = field.createValue(reader.getValue());
                }
                groupValue.setFieldValue(field, value);
            } else {
                System.err.println("Warning: skipping unexpected field '" + reader.getNodeName() + "'");
            }
            reader.moveUp();
        }
    }

    private void parseSequence(HierarchicalStreamReader reader, Sequence sequence, SequenceValue value) {
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            GroupValue current = (GroupValue)sequence.getGroup().createValue(null);
            this.parseGroup(reader, sequence.getGroup(), current);
            value.add(current);
            reader.moveUp();
        }
    }

    public boolean canConvert(Class clazz) {
        return clazz.equals(Message.class);
    }

    protected TemplateRegistry getTemplateRegistry() {
        return this.templateRegistry;
    }

    public void setTemplateRegistry(TemplateRegistry templateRegistry) {
        this.templateRegistry = templateRegistry;
    }
}

