% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Point_map.R
\name{Point_map}
\alias{Point_map}
\title{A function to map statistics as colored points on a map.}
\usage{
Point_map(
  dat,
  statistic,
  size = 3,
  breaks = NULL,
  col,
  out.col = NULL,
  Lat_buffer = 1,
  Long_buffer = 1,
  Latitude_col = NULL,
  Longitude_col = NULL
)
}
\arguments{
\item{dat}{Data frame or character string that supplies the input data. If it is a character string, the file should be a csv. The first column should be the statistic to be plotted. The coordinates of each row should be indicated by columns named Longitude and Latitude. Alternatively, see the Longitude_col and Latitude_col arguments.}

\item{statistic}{Character string. The statistic to be plotted.}

\item{size}{Numeric. The size of the points to plot.}

\item{breaks}{Numeric. The breaks used to generate the color ramp when plotting. Users should supply 3 values if custom breaks are desired.}

\item{col}{Character vector indicating the colors you wish to use for plotting, three colors are allowed (low, mid, high). The first color will be the low color, the second the middle, the third the high.}

\item{out.col}{Character. A color for outlining points on the map. There will be no visible outline if left as NULL.}

\item{Lat_buffer}{Numeric. A buffer to customize visualization.}

\item{Long_buffer}{Numeric. A buffer to customize visualization.}

\item{Latitude_col}{Numeric. The number of the column indicating the latitude for each sample. If this is not null, PopGenHelpR will use this column instead of looking for the Latitude column.}

\item{Longitude_col}{Numeric. The number of the column indicating the longitude for each sample. If this is not null, PopGenHelpR will use this column instead of looking for the Longitude column.}
}
\value{
A list containing maps and the data frames used to generate them.
}
\description{
A function to map statistics as colored points on a map.
}
\examples{
\donttest{
data(Het_dat)
Test <- Point_map(Het_dat, statistic = "Heterozygosity")}
}
\author{
Keaka Farleigh
}
