% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Div_Stats.R
\name{Div_stats}
\alias{Div_stats}
\title{A function to estimate heterozygosity and the number of private alleles from a vcf file.}
\usage{
Div_stats(VCF, pops, ploidy, prefix)
}
\arguments{
\item{VCF}{Character string indicating the name of the vcf file to be used in analysis.}

\item{pops}{Character string indicating the name of the population assignment file. This file should have four columns and be in the same order as your vcf file. The first column named Sample indicates the sample name. The second column named Population indicates the population assignment of each individual. The third column named Long indicates the longitude of the sample.  The fourth column named Lat indicates the latitude of the sample.}

\item{ploidy}{Numeric. The ploidy of the data.}

\item{prefix}{Character string that will be appended to file output.}
}
\value{
A list containing the estimated diversity statistics, model output from linear regression of these statistics against latitude, and model plots.
}
\description{
A function to estimate heterozygosity and the number of private alleles from a vcf file.
}
\examples{
\donttest{
Test <- Div_stats('my_vcf.vcf', 'my_popmap.csv',
ploidy = 2, prefix = 'Test')}
}
