% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/start_parallel.R
\name{start_parallel}
\alias{start_parallel}
\title{Start parallel computational processes}
\usage{
start_parallel(
  parallel = TRUE,
  num_cores = NULL,
  parallel_type = NULL,
  seed = NULL,
  dlls = NULL,
  mrgsolve_model = NULL,
  ...
)
}
\arguments{
\item{parallel}{Should the parallel functionality start up?}

\item{num_cores}{How many cores to use.  Default is
\code{parallel::detectCores()}. See \code{\link[parallel]{detectCores}} for more information.}

\item{parallel_type}{Which type of parallelization should be used? Can be
"snow" or "multicore".  "snow"  works on Linux-like systems & Windows.
"multicore" works only on Linux-like systems.  By default this is chosen
for you depending on your operating system.}

\item{seed}{The random seed to use.}

\item{dlls}{If the computations require compiled code (DLL's) and you are
using the "snow" method then you need to specify the name of the DLL's without 
the extension as a text vector \code{c("this_file","that_file")}.}

\item{mrgsolve_model}{If the computations require a mrgsolve model and you 
are using the "snow" method" then you need to specify the name of the model 
object created by \code{mread} or \code{mcode}}

\item{...}{Arguments passed to \code{\link[parallel]{makeCluster}}}
}
\value{
An atomic vector (TRUE or FALSE) with two attributes: "type" and "cores".
}
\description{
This tool chooses the type of parallelization process to use based on the
computer OS being used.  For windows the default is "snow" and for Linux-like
systems the default is "multicore"
}
