% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PolynomF.R
\name{plot.polylist}
\alias{plot.polylist}
\alias{plot.polynom}
\alias{lines.polynom}
\alias{points.polynom}
\alias{lines.polylist}
\alias{points.polylist}
\title{Plot method for polynomials}
\usage{
\method{plot}{polylist}(x, xlim = 0:1, ylim = range(Px), type = "l",
  xlab = "x", ylab = "P(x)", ..., col = seq_along(x), lty = if
  (length(col) == 1) seq_along(x) else "solid", len = 1000,
  legend = FALSE)

\method{plot}{polynom}(x, xlim = 0:1, ylim = range(Px), type = "l",
  xlab = "x", ylab = "p(x)", ..., len = 1000, limits = pu[1:2])

\method{lines}{polynom}(x, ..., len = 1000, limits = pu[1:2])

\method{points}{polynom}(x, ..., len = 100, limits = pu[1:2])

\method{lines}{polylist}(x, ..., len = 1000, limits = pu[1:2],
  col = seq_along(x), lty = if (length(col) == 1) seq_along(x) else
  "solid")

\method{points}{polylist}(x, ..., len = 100)
}
\arguments{
\item{x}{A polynom or polylist object to be plotted}

\item{xlim, ylim}{as for graphics::plot}

\item{type}{as for graphics::plot}

\item{xlab, ylab}{as for graphics::plot}

\item{...}{additional arguments passed on to methods}

\item{col, lty}{Colour(s) and line type(s) as for graphics::plot}

\item{len}{positive integer defining the point or curve resolution}

\item{legend}{logical: for "polylist" objects, should a legend be drawn alongside the main plot?}

\item{limits}{x-limits for the polynomial, default: the entire plot.
For polylist objects this may be a two column matrix.}
}
\value{
Nothing of interest, invisibly
}
\description{
Plot methods for polynom or polylist objects
}
\examples{
p <- poly_from_zeros((-3):4)
plot(p)
lines(deriv(p), col = "red")
}
