% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meshes.R
\name{plotEdges}
\alias{plotEdges}
\title{Plot some edges}
\usage{
plotEdges(
  vertices,
  edges,
  color = "black",
  lwd = 2,
  edgesAsTubes = TRUE,
  tubesRadius = 0.03,
  verticesAsSpheres = TRUE,
  only = NULL,
  spheresRadius = 0.05,
  spheresColor = color
)
}
\arguments{
\item{vertices}{a three-columns matrix giving the coordinates of the vertices}

\item{edges}{a two-columns integer matrix giving the edges by pairs of
vertex indices}

\item{color}{a color for the edges}

\item{lwd}{line width, a positive number, ignored if \code{edgesAsTubes=TRUE}}

\item{edgesAsTubes}{Boolean, whether to draw the edges as tubes}

\item{tubesRadius}{the radius of the tubes when \code{edgesAsTubes=TRUE}}

\item{verticesAsSpheres}{Boolean, whether to draw the vertices as spheres}

\item{only}{integer vector made of the indices of the vertices you want
to plot (as spheres), or \code{NULL} to plot all vertices}

\item{spheresRadius}{the radius of the spheres when
\code{verticesAsSpheres=TRUE}}

\item{spheresColor}{the color of the spheres when
\code{verticesAsSpheres=TRUE}}
}
\value{
No value.
}
\description{
Plot the given edges with \strong{rgl}.
}
\examples{
library(PolygonSoup)
library(rgl)

\donttest{# we triangulate the truncated icosahedron mesh
mesh <- Mesh(
  mesh = truncatedIcosahedron,
  triangulate = TRUE, normals = FALSE
)
# now we can plot the truncated icosahedron
tmesh <- toRGL(mesh)
open3d(windowRect = c(50, 50, 562, 562), zoom = 0.9)
shade3d(tmesh, color = "gold")
# we plot the edges given in `mesh[["edges0"]]`; these are the 
# edges of the mesh before the triangulation
plotEdges(mesh[["vertices"]], mesh[["edges0"]], color = "navy")}

# we triangulate the pentagrammic prism mesh
mesh <- Mesh(
  mesh = pentagrammicPrism,
  triangulate = TRUE, normals = FALSE
)
# now we can plot the pentagrammic prism
tmesh <- toRGL(mesh)
\donttest{open3d(windowRect = c(50, 50, 562, 562), zoom = 0.9)
shade3d(tmesh, color = "navy")
# we plot the exterior edges only, given in `mesh[["exteriorEdges"]]`
plotEdges(
  mesh[["vertices"]], mesh[["exteriorEdges"]], color = "gold",
  tubesRadius = 0.02, spheresRadius = 0.02
)}

# or only plot the edges whose corresponding dihedral angle is acute:
allEdges <- mesh[["edgesDF"]]
edges <- as.matrix(subset(allEdges, angle <= 91, select = c("i1", "i2")))
}
