% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PolyHaplotyper.R
\name{calcStatistics}
\alias{calcStatistics}
\title{calculate some statistics of the solutions of all haploblocks}
\usage{
calcStatistics(pedchk, ovwFS, indiv, haploblocks)
}
\arguments{
\item{pedchk}{a list as generated by pedigreeHapCheck}

\item{ovwFS}{a list as produced by overviewFS, or NA if no FS families
available. If ovwFS is specified, pedchk and ovwFS should have
been calculated from the same underlying data}

\item{indiv}{missing, NULL or a vector of names of individuals. If present,
the component pedstats is calculated only over the individuals in the vector,
else over all individuals. Component FSstats is not affected by indiv}

\item{haploblocks}{missing, NULL or a vector of names or numbers of
haploblocks, or a list of haploblocks as in the inferHaplotypes input.
If present, components pedstats and FSstats are calculated only over the
specified haploblocks, else over all haploblocks.}
}
\value{
a list with one or two items:\cr
pedstats: a data.frame with one row per haploblock, showing numbers
of individuals in columns\cr
- mrk: individuals with complete marker data\cr
- hap: individuals with an assigned haplotype combination\cr
- match.NA: individuals where a match between the haplotypes of the individual
 and its parents could not be verified (either the individual itself or both
 parents have no haplotype combination assigned)\cr
- noDR.TRUE: individuals whose haplotype combination matches that of its
 parents, assuming polysomic inheritance without Double Reduction\cr
- noDR.FALSE: individuals whose haplotype combination doesn't match that of its
 parents, assuming polysomic inheritance without Double Reduction\cr
- withDR.TRUE: individuals whose haplotype combination matches that of its
 parents, assuming polysomic inheritance, allowing Double Reduction\cr
- withDR.FALSE: individuals whose haplotype combination doesn't match that of
 its parents, assuming polysomic inheritance, allowing Double Reduction\cr
The total number of individuals is \cr
match.NA + noDR.TRUE + noDR.FALSE == match.NA + withDR.TRUE + withDR.FALSE;\cr
the number of individuals with missing marker data or without assigned
haplotype dosages can be calculated by subtracting mrk or hap from that
total.\cr
FSstats (only if ovwFS specified): a data.frame with for each FS family,
"rest" and "all" one row, with columns\cr
- pop: the FS family numbers, "rest" (all individuals not belonging to the
 FSs or their parents) and "all" (all individuals)\cr
- bothparmrk: for how many haploblocks have both parents complete marker data?\cr
- FSdone: for how many haploblocks has a solution based on polysomic
 inheritance been found for this FS family?\cr
- mrk: the average number of (FS) individuals with complete marker data\cr
- imp: the average number of (FS) individuals with imputed marker data\cr
- hap: the average number of (FS) individuals with an assigned haplotype
 combination\cr
The numbers for "all" include also the FS parents (each parent counted only
once, even if some parents produced more than one FS family), which are not
included in any of the other rows; therefore "all" is not equal to the sum of
the rows above.
}
\description{
calculate some statistics of the solutions of all haploblocks
}
\examples{
data(PolyHaplotyper_small)
phchk <- pedigreeHapCheck(ped=phped, mrkDosage=phdos, haploblock=phblocks,
                          hapresults=phresults)
phovw <- overviewByFS(haploblock=phblocks, parents=phpar, FS=phFS,
                     hapresults=phresults)
calcStatistics(pedchk=phchk, ovwFS=phovw)
}
