% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VDJ_db_load.R
\name{VDJ_db_load}
\alias{VDJ_db_load}
\title{Load and preprocess a list of antigen-specific databases}
\usage{
VDJ_db_load(
  databases,
  file.paths,
  preprocess,
  species,
  filter.sequences,
  remove.na,
  vgm.names,
  keep.only.common,
  output.format,
  saving.path
)
}
\arguments{
\item{databases}{list of databases to be processed and saved. Currently supported ones include: VDJdb(='vdjdb'), McPAS-TCR(='mcpas'), TBAdb(='tbdadb_tcr' or 'tbadb_bcr').}

\item{file.paths}{list of file paths for the specified databases (in the database parameter). If NULL, will try to locally download the databases from the archived download links.}

\item{preprocess}{boolean - if T, will preprocess each database individually.}

\item{species}{string - either 'Human' or 'Mouse', the species for the processed database. Needs preprocess=T.}

\item{filter.sequences}{string - 'VDJ' to remove rows with NA VDJ sequences, 'VJ' to remove rows with NA VJ sequences, 'VDJ.VJ' to remove rows with both VDJ and VJ sequences missing. Needs preprocess=T.}

\item{remove.na}{string or NULL - 'all' will remove all rows with missing values from the database, 'common' will remove only rows with missing values for the shared columns among all databases ('VJ_cdr3s_aa','VDJ_cdr3s_aa','Species','Epitope','Antigen species'), 'vgm' will remove missing values for columns shared with the VDJ object (specific to each database). Needs preprocess=T.}

\item{vgm.names}{boolean - if T, will change all column names of the shared columns (with VDJ) to match those from VDJ. Use this to integrate the antigen data into VDJ using VDJ_antigen_integrate or VDJ_db_annotate. Needs preprocess=T.}

\item{keep.only.common}{boolean - if T, will only keep the columns shared between all databases ('VJ_cdr3s_aa','VDJ_cdr3s_aa','Species','Epitope','Antigen species') for each processed database. Needs preprocess=T.}

\item{output.format}{string - 'df.list' to save all databases as a list, 'save' to save them as csv files.}

\item{saving.path}{string - directory where the processed databases should be locally saved if output.format='save'.}
}
\value{
Processed antigen-specific databases for both TCRs and BCRs.
}
\description{
Preprocessing function for several antigen databases for both TCRs (VDJdb, McPAS-TCR, TBAdb) and BCRs (TBAdb), saving them either at a specified path, or loading them as a database list for downstream integration/analyses.
}
\examples{
\donttest{
try({
VDJ_db_load(databases=list('vdjdb'),file.paths=NULL,
preprocess=TRUE,species='Mouse',filter.sequences='VDJ.VJ',
remove.na='vgm', vgm.names=TRUE, keep.only.common=TRUE,
output.format='df.list', saving.path = tempdir())
})
}
}
