% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Spatial_marker_expression.R
\name{Spatial_marker_expression}
\alias{Spatial_marker_expression}
\title{Plotting a gene of interest in selected cells on the spatial image.}
\usage{
Spatial_marker_expression(
  sample_names,
  bcs_merge,
  images_tibble,
  matrix,
  marker,
  GEX_barcode,
  title,
  threshold,
  size
)
}
\arguments{
\item{sample_names}{Character vector containing the name of the sample.}

\item{bcs_merge}{Data frame containing imagerow, imagecol and barcode of the cells belonging to the spatial image. It can also be created by the function scaling_spatial_image_parameter by selecting the output parameter 10.}

\item{images_tibble}{Tbl-df containing the sample name, grob, height and width of the spatial image. It can also be created by the function scaling_spatial_image_parameter by selecting the output parameter 5.}

\item{matrix}{Data frame containing all the genes detected per cells. This data frame can be obtained by the scaling_parameters functions.}

\item{marker}{Character vector containing the name of a gene of interest.}

\item{GEX_barcode}{Character vector containing the GEX barcode of the cell of interest with the -1 at the end}

\item{title}{Character vector to name the plot.}

\item{threshold}{Number, to define the threshold. If threshold = No, plot of the module and if threshold is a number, plot show the cells above the threshold.}

\item{size}{Number, to define the size of the text, default = 15.}
}
\value{
Returns a plot of the level of expression of a gene in cells.
}
\description{
Plotting a gene of interest in selected cells on the spatial image.
}
\examples{
\dontrun{
GEX_BCR_barcode<-vgm_with_simulated_VDJ$VDJ$GEX_barcode
GEX_BCR_barcode<-paste0(GEX_BCR_barcode,"-1") #Add -1 at the end of each barcode
#Without expression threshold
Spatial_marker_expression(matrix=scaling_parameters[[9]],
marker="CD3E",bcs_merge=scaling_parameters[[10]],
images_tibble=scaling_parameters[[5]],
GEX_barcode=GEX_BCR_barcode,sample_names=sample_names, title = "B cells",
threshold = "No")

#With expression threshold
Spatial_marker_expression(matrix=scaling_parameters[[9]],
marker="CD3E",bcs_merge=scaling_parameters[[10]],
images_tibble=scaling_parameters[[5]],
GEX_barcode=GEX_BCR_barcode,sample_names=sample_names, title = "B cells",
threshold = 5)
}
}
