% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\docType{data}
\name{background_error_rate}
\alias{background_error_rate}
\alias{background_error_rate.txt}
\title{The package provide the SNV and INDEL PERs computed for the Ion AmpliSeq™ Colon and Lung Cancer Panel v2 from 29 controls in a table available in the data file \code{background_error_rate.txt}.}
\usage{
data(background_error_rate)
}
\description{
This table contains 9 variables for each genomic position
\itemize{
  \item \code{chrpos}, char, of the form chrN:XXXXXXXXX defining genomic position
  \item \code{N0}, integer, the coverture in the controls
  \item \code{E0}, integer, the number of errors in the controls
  \item \code{p.sain}, numeric,  the ratio E0/N0
  \item \code{up.sain}, numeric, the 95th quantile of the Binomial with parameter N0 and E0/N0
  \item \code{E0indel}, integer, the amount of indel
  \item \code{indel.p.sain}, numeric, the ration E0indel/N0
  \item \code{indel.up.sain}, numeric, the 95th quantile of the Binomial with parameter N0 and E0indel/N0
  \item \code{hotspot}, char, either 'Non-hotspot' or 'Hotspot' depending if the genomic position is known as hotspot or not.
}
}
\author{
N. Pécuchet, P. Laurent-Puig and Y. Rozenholc
}
\references{
\emph{Analysis of base-position error rate of next-generation sequencing to detect tumor mutations in circulating DNA} N. Pécuchet, Y. Rozenholc, E. Zonta, D. Pietraz, A. Didelot, P. Combe, L. Gibault, J-B. Bachet, V. Taly, E. Fabre, H. Blons, P. Laurent-Puig in \emph{Clinical Chemistry}
}
\seealso{
\code{BuildCtrlErrorRate}
}
\keyword{data}

