% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nicfi_utils.R
\name{nicfi_mosaics}
\alias{nicfi_mosaics}
\title{Returns all 'monthly' or 'bi-annually' mosaic files of the NICFI data}
\usage{
nicfi_mosaics(
  planet_api_key,
  type = "monthly",
  crs_bbox = 4326,
  URL = "https://api.planet.com/basemaps/v1/mosaics",
  verbose = FALSE
)
}
\arguments{
\item{planet_api_key}{a character string specifying the Planet API key (see the references on how to acquire this key)}

\item{type}{a character string specifying the type of NICFI data. It can be either 'monthly' or 'bi_annually'}

\item{crs_bbox}{an integer specifying the Coordinates Reference System for the bounding box computation only.}

\item{URL}{this character string specifies the default URL which is required to come to the output mosaic metadata information}

\item{verbose}{a boolean. If TRUE then information will be printed out in the console}
}
\value{
an object of class list
}
\description{
Returns all 'monthly' or 'bi-annually' mosaic files of the NICFI data
}
\examples{

\dontrun{

require(PlanetNICFI)

api_key = 'use_your_planet_nicfi_API_key'

#........
# monthly
#........

mosaic_files = nicfi_mosaics(planet_api_key = api_key,
                             type = 'monthly',
                             crs_bbox = 4326,
                             URL = 'https://api.planet.com/basemaps/v1/mosaics',
                             verbose = TRUE)
#............
# bi-annually
#............

mosaic_files = nicfi_mosaics(planet_api_key = api_key,
                             type = 'bi_annually',
                             crs_bbox = 4326,
                             URL = 'https://api.planet.com/basemaps/v1/mosaics',
                             verbose = TRUE)
}
}
\references{
https://developers.planet.com/quickstart/

https://developers.planet.com/quickstart/apis/

https://developers.planet.com/docs/basemaps/reference/#tag/Basemaps-and-Mosaics
}
