% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nicfi_utils.R
\name{create_VRT_from_dir}
\alias{create_VRT_from_dir}
\title{Create a Virtual Raster (VRT) file from the .tif files}
\usage{
create_VRT_from_dir(
  dir_tifs,
  output_path_VRT,
  file_extension = ".tif",
  verbose = FALSE
)
}
\arguments{
\item{dir_tifs}{a valid path to a directory where the .tif files are saved}

\item{output_path_VRT}{a valid path to a file where the Virtual Raster (VRT) will be saved}

\item{file_extension}{a character string specifying the image file extension from which the .vrt file will be built}

\item{verbose}{a boolean. If TRUE then information will be printed out in the console}
}
\value{
it doesn't return an object but it saves the output to a file
}
\description{
Create a Virtual Raster (VRT) file from the .tif files
}
\examples{

\dontrun{

require(PlanetNICFI)

#....................................
# first extract the available Mosaics
#....................................

api_key = 'use_your_planet_nicfi_API_key'

mosaic_files = nicfi_mosaics(planet_api_key = api_key,
                             type = 'monthly',
                             crs_bbox = 4326,
                             URL = 'https://api.planet.com/basemaps/v1/mosaics',
                             verbose = TRUE)

#....................................
# keep the mosaic of 'September 2020'
#....................................

keep_idx = 1
mosaic_ID = mosaic_files$dtbl_mosaic$id[keep_idx]


#................................................................
# then extract the available Quad files for the Mosaic for an AOI
#................................................................

wkt_file = system.file('data_files/Sugar_Cane_Bolivia.wkt', package = "PlanetNICFI")
WKT = readLines(wkt_file, warn = FALSE)

quad_files = nicfi_quads_bbox(planet_api_key = api_key,
                              mosaic_id = mosaic_ID,
                              bbox_AOI = NULL,
                              wkt_AOI = WKT,
                              page_size = 10,
                              crs_bbox = 4326,
                              verbose = TRUE)

#..................................
# formated aria2c download weblinks
#..................................

web_links_aria2c = aria2c_download_paths(mosaic_output = mosaic_files,
                                         mosaic_id = mosaic_ID,
                                         quads_output = quad_files,
                                         img_type = 'tif')

#.........................................................
# download the .tif files that intersect with the bbox AOI
#.........................................................

temp_dir_out = tempdir()

all_threads = parallel::detectCores()
set_threads = length(web_links_aria2c) / 2
num_threads = ifelse(set_threads < all_threads, set_threads, all_threads)
aria_args = '--allow-overwrite --file-allocation=none --retry-wait=5 --max-tries=0'

res_downl = aria2c_bulk_donwload(vector_or_file_path = web_links_aria2c,
                                 default_directory = temp_dir_out,
                                 user = NULL,
                                 password = NULL,
                                 threads = num_threads,
                                 verbose = TRUE,
                                 secondary_args_aria = aria_args)

#........................................
# create a Virtual Raster (VRT) file from
# the downloaded .tif files
#........................................

VRT_out = file.path(temp_dir_out, glue::glue("{mosaic_ID}.vrt"))

res_vrt = create_VRT_from_dir(dir_tifs = temp_dir_out,
                              output_path_VRT = VRT_out,
                              file_extension = '.tif',
                              verbose = TRUE)

#......................................................
# load the saved VRT file as raster (which might
# consist of multiple files, i.e. a mosaic) and plot it
#......................................................

rst = raster::raster(VRT_out)
sp::plot(rst, axes = F, legend = F)

}
}
