% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_selection.R
\name{penalty_BaraudGiraudHuet_likelihood}
\alias{penalty_BaraudGiraudHuet_likelihood}
\title{Penalty function type Baraud Giraud Huet.}
\usage{
penalty_BaraudGiraudHuet_likelihood(K, model_complexity, ntaxa, C = 1.1)
}
\arguments{
\item{K}{the dimension of the model.}

\item{model_complexity}{the complexity of the set of models with dimention K.}

\item{ntaxa}{the number of tips.}

\item{C}{a constant, C > 1. Default is C = 1.1
(as suggested in Baraud Giraud Huet (2009))}
}
\value{
value of the penalty.
}
\description{
\code{penalty_BaraudGiraudHuet_likelihood} is the penalty defined by : 
pen' = ntaxa * log(1 + pen/(ntaxa - K)) with 
pen = C * (ntaxa - K)/(ntaxa - K - 1) * EDkhi[K + 1; ntaxa - K - 1; exp(-Delta_K)/(K + 1)]
and Delta = log(model_complexity) + log(K + 1) 
such that sum(exp(-Delta_K)) < infty.
}
\details{
See Baraud Giraud Huet (2009, 2011).
Must be applied to log-likelihood crierion.
Function pen is computed using function \code{penalty} from package
\code{LINselect}.
}
\seealso{
\code{\link{penalty_BirgeMassart_shape1}},
\code{\link{penalty_BirgeMassart_shape2}}
}
\keyword{internal}
