% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/E_step.R
\name{compute_mean_variance.simple}
\alias{compute_mean_variance.simple}
\title{Compute moments of params_old}
\usage{
compute_mean_variance.simple(phylo, times_shared, distances_phylo,
  process = c("BM", "OU", "rBM", "scOU"), params_old,
  masque_data = c(rep(TRUE, attr(params_old, "p_dim") *
  length(phylo$tip.label)), rep(FALSE, attr(params_old, "p_dim") *
  phylo$Nnode)), sim = NULL, U_tree = NULL, ...)
}
\arguments{
\item{phylo}{Input tree.}

\item{times_shared}{(matrix) : times of shared ancestry, result of function 
\code{compute_times_ca}}

\item{distances_phylo}{(matrix) : phylogenetics distance, result of function 
\code{compute_dist_phy}}

\item{process}{a two letter string indicating the process to consider}

\item{params_old}{a list of parameters to be used in the computations}
}
\value{
sim (list) : result of funtion \code{simulate} with the appropriate
 parameters

Sigma matrix of variance covariance, result of function 
\code{compute_variance_covariance}
#@return Sigma_YY_inv inverse of vairance matrix of the data

Sigma_YY_chol_inv invert of cholesky matrix of Sigma_YY:
 (Sigma_YY)^(-1) = tcrossprod(Sigma_YY_chol_inv)
}
\description{
\code{compute_mean_variance.simple} computes the quantities needed to compute
mean and variance matrix with parameters params_old.
}
\details{
This function is used by functions \code{compute_E.simple} and 
\code{compute_log_likelihood.simple}.
}
\keyword{internal}

