% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/populationDiagnostics.R
\name{populationDiagnostics}
\alias{populationDiagnostics}
\title{Population-level diagnostics}
\usage{
populationDiagnostics(
  cohort,
  populationSample = 1e+06,
  populationDateRange = as.Date(c(NA, NA))
)
}
\arguments{
\item{cohort}{Cohort table in a cdm reference}

\item{populationSample}{Number of people from the cdm to sample. If NULL no
sampling will be performed}

\item{populationDateRange}{Two dates. The first indicating the earliest cohort
start date and the second indicating the latest possible cohort end date. If
NULL or the first date is set as missing, the earliest observation_start_date
in the observation_period table will be used for the former. If  NULL or the
second date is set as missing, the latest observation_end_date in the
observation_period table will be used for the latter.}
}
\value{
A summarised result
}
\description{
phenotypeR diagnostics on the cohort of input with relation to a denomination
population. Diagnostics include:

* Incidence
* Prevalence
}
\examples{
\donttest{
library(IncidencePrevalence)
cdm <- mockIncidencePrevalenceRef(sampleSize = 1000)
pop_diag <- populationDiagnostics(cohort = cdm$outcome,
                                  populationSample = 250)
CDMConnector::cdm_disconnect(cdm)
}
}
