% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SimPhase3.R
\name{SimPhase3}
\alias{SimPhase3}
\title{Performs one replication of phase 3 for the phase 123 design, given phase 12 data.}
\usage{
SimPhase3(Dose, Phase12, PE, PT, Hypermeans, Hypervars, betaA, ProbC,
  betaC, Family, alpha, Nmax, Opt, Accrue, Time12, Twait, NLookSwitch,
  NLook, Sup, Fut)
}
\arguments{
\item{Dose}{Vector of standardized doses considered in the trial.}

\item{Phase12}{Matrix Consisting of patient data from a phase 12 trial. The columns are in order: Doses given, YE, YT, Accrual Times}

\item{PE}{True efficacy dose-toxicity vector.}

\item{PT}{True toxicity dose-toxicity vector.}

\item{Hypermeans}{Prior Means for the Eff-Tox design of length 6.}

\item{Hypervars}{Prior Variances for the Eff-Tox design of length 6.}

\item{betaA}{True linear term for the rate or mean parameter (beta_1,exp(beta_E),-exp(beta_T),beta_2,beta_0) for agent A.}

\item{ProbC}{Probability of efficacy and toxicity for the control therapy.}

\item{betaC}{Linear term for efficacy, toxicity and beta_0 for the control group.}

\item{Family}{Time to event distribution. Options include: Exponential, Gamma, Weibull, Lognormal.}

\item{alpha}{Shape parameter or standard deviation of a lognormal distribution.}

\item{Nmax}{Maximum number of patients to enroll in phase 3.}

\item{Opt}{Dose used for A to begin randomization in phase 3.}

\item{Accrue}{Accrual rate for patients in phase 3.}

\item{Time12}{Time window for phase 12.}

\item{Twait}{Waiting time in between phase 12 and phase 3.}

\item{NLookSwitch}{Number of patient events to determine if we re-optimize doses for A.}

\item{NLook}{Vector of information criteria for making interim looks.}

\item{Sup}{Vector of superiority boundaries.}

\item{Fut}{Vector of futility boundaries.}
}
\description{
This function simulates the phase 3 potion of the phase 123 trial, given phase 12 outcomes.
}
\examples{
library(survival)
##True Efficacy and Toxicity Probabilities
PT = c(.1,.15,.25,.35,.5)
PE=c(.2,.4,.6,.65,.7)
##Dose Levels considered
Dose = c(1,2,3,3.5,5)
Dose=(Dose-mean(Dose))/sd(Dose)
##Average accrual rate for phase III
Accrue = 10
#'##Hypermeans for Eff-Tox
Hypermeans = c(.022,3.45,0,-4.23,3.1,0)
Hypervars = c(2.6761, 2.6852, .2, 3.1304, 3.1165, 1)
Hypervars=Hypervars^2
Contour = c(.35, .75,.7,.4)
PiLim = c(.3,.4)
ProbLim=c(.1,.1)
###Family of Distributions
Family="Exponential"
###Shape parameter ## Doesn't matter for exponential distribution
alpha=1
###True Beta vector
betaA = c(.75,-.5, .3, -.25,2.143)
##True beta vector for efficacy, toxicity and intercept of the control treatment
betaC=c(.3,-.25,2.389)
##True efficacy and toxicity probability for control group
ProbC = c(.4,.15)
##Waiting time in between
Twait=1
###How long is the time window in phase 12?
Time12=1
##Dose to start phase 3 with
Opt=3
##Make matrix with old phase 12 data
Doses= c(1,1,1,2,2,2,1,1,1,3,3,3,1,1,1,2,2,2)
YE = c(0,0,1,1,1,0,0,0,0,1,1,1,0,0,1,1,1,0)
YT=c(0,0,0,1,1,0,1,0,0,1,1,1,0,0,0,1,0,0)
##Accrual Times for old data
Accrue12=2
##Size of phase 12 cohort
cohort=3
ACC1=cumsum(rexp(length(YT),Accrue12))
##Accrual times are the same for each cohort in phase 12
Grab = rep(NA,length(YT)/cohort)
for(m in 1:length(Grab)){Grab[m]=ACC1[m*3]}
for(m in 1:length(Grab)){ACC1[((m-1)*cohort+1):((m-1)*cohort+cohort)]=rep(Grab[m],cohort)}
Phase12 = cbind(Doses,YE,YT,ACC1)
betaC=c(.3,-.25,2.389)
##True efficacy and toxicity probability for control group
ProbC = c(.4,.15)
##Max Sample Size
Nmax=500
###Number of patient events to Re-optimize doses
NLookSwitch = 50
##Number of patient events for interim looks
NLook = c(200,300,400)
##Superiority Boundaries
Sup = c(2.96, 2.53,1.99)
##Futility Boundaries (0 means no futility decision)
Fut = c(0,1.001,0)
##Starting Dose, hat(x)_ET
Opt=3
##Number of simulations to run
nSims=10
SimPhase3(Dose,Phase12,PE,PT,Hypermeans,Hypervars,betaA,
ProbC,betaC,Family,alpha,Nmax,Opt,Accrue,
Time12,Twait,NLookSwitch,NLook,Sup,Fut)
}
\references{
[1] Chapple and Thall (2018).A Hybrid Phase I-II/III Clinical Trial Design Allowing Dose Re-Optimization in Phase III. Biometrics. In Press,
}
