\encoding{UTF-8}
\name{GPS}
\alias{GPS}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{Gamma Poisson Shrinkage}
\description{
 Gamma Poisson Shrinkage model proposed by DuMouchel (1999) extended to the multiple comparison framework. 
}
\usage{
GPS(DATABASE,  RR0 = 1, MIN.n11 = 1, DECISION = 1, DECISION.THRES = 0.05, 
RANKSTAT = 1, TRONC = FALSE, TRONC.THRES = 1,   
PRIOR.INIT = c(alpha1 = 0.2, beta1 = 0.06, alpha2 = 1.4,
beta2 = 1.8, w = 0.1), PRIOR.PARAM = NULL)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{DATABASE}{Object returned by the function \code{as.PhViD}.}
  \item{RR0}{Value of the tested risk. By default, \code{RR0=1}.}
  \item{MIN.n11}{Minimum number of notifications for a couple to be potentially considered as a signal. This option does not affect the calculation of the hyper parameters. By default, \code{MIN.n11 = 1}.}
  \item{DECISION}{Decision rule for the signal generation based on

                 1 = FDR (Default value)

                 2 = Number of signals

                 3 = Ranking statistic. See \code{RANKSTAT}}
  \item{DECISION.THRES}{Threshold for \code{DECISION}. Ex 0.05 for FDR (\code{DECISION}=1). }
  \item{RANKSTAT}{Statistic used for ranking the couples:

                 1 = Posterior probability of the null hypothesis

                 2 = 5\% quantile of the posterior distribution of \eqn{\lambda}{lambda}

                 3 = Posterior Expectation of \eqn{\log_2(\lambda)}{log(lambda,2)}} 
  \item{TRONC}{If TRUE, only the data with at least \code{TRONC.THRES} notifications are considered in the calculation of the hyper parameters and the likelihood is a product of mixture of two negative binomial truncated by \code{TRONC.THRES-1}. By default, \code{TRONC=F}}
  \item{TRONC.THRES}{See \code{TRONC} }
  \item{PRIOR.INIT}{Vector of initialization of the prior parameters \eqn{(\alpha_1, \beta_1, \alpha_2, \beta_2, w)}{(alpha1, beta1, alpha2, beta2, w)}. By default, \code{PRIOR.INIT} \eqn{= c(\alpha_1 = 0.2, \beta_1 = 0.06, \alpha_2 = 1.4, \beta_2 = 1.8, w = 0.1)}{= c(alpha1 = 0.2, beta1 = 0.06, alpha2 = 1.4, beta2 = 1.8, w = 0.1)}, ie the prior parameters found in DuMouchel (1999).}
  \item{PRIOR.PARAM}{Chosen hyper parameters. By default, \code{PRIOR.PARAM} = NULL which means that the hyperparameters are calculated by maximising the marginal likelihood.}
}
\details{
Each observed count \eqn{n_{11}}{n11} is assumed to be drawn from a Poisson distribution with parameters 
\eqn{e_{11}}{e11} where \eqn{e_{11}}{e11} is the expected count under the hypothesis of independence between the adverse events and the drugs (\eqn{n1. \times n.1 / N}{n1. * n.1 / N}, see \code{\link{as.PhViD}}). \eqn{\lambda}{lambda} is a priori assumed to be distributed according to a mixture of two gamma distributions: \eqn{\lambda \sim w \: \Gamma(\alpha_1,\beta_1) + (1-w) \: \Gamma(\alpha_2,\beta_2)}{lambda ~ w Ga(alpha1,beta1) + (1-w) Ga(alpha2,beta2)}.}
\value{
  \item{ALLSIGNALS}{Data.frame summarizing the results of all couples with at least \code{MIN.n11} notifications ordered by \code{RANKSTAT}. It contains notably the labels, the cell counts, the expected counts, \code{RANKSTAT}, the ratios(count/expected count), the marginal counts and the estimations of FDR, FNR, Se et Sp. If \code{RANKSTAT!=1}, the last column is the posterior probability of the null hypothesis.}
  \item{SIGNALS}{Same Data.frame as \code{ALLSIGNALS} but restricted to the list of generated signals.}
  \item{NB.SIGNALS}{Number of generated signals.} 
  \item{INPUT.PARAM}{Parameters entered in the function.}
  \item{PARAM}{A list that contains the prior hyper parameters (\code{PRIOR.PARAM}). Additionally if \code{PRIOR.PARAM=NULL}, it also contains the prior hyper parameters initialization (\code{PRIOR.INIT}) and the convergence code (see \code{nlm()}).}
}
\references{
Ahmed I, Haramburu F, Fourrier-Réglat A, Thiessard F, Kreft-Jais C, Miremont-Salamé G, Bégaud B, Tubert-Bitter P. Bayesian pharmacovigilance signal detection methods revisited in a multiple comparison setting. Stat Med. 2009 Jun 15;28(13):1774-1792. 

DuMouchel W, Bayesian Data Mining in Large Frequency Tables, with an Application to the FDA Spontaneous Reporting System, The American Statistician, 1999, 53, 177-190.

Szarfman A, Machado S, O'Neill R, Use of Screening Algorithms and Computer Systems to Efficiently Signal Higher-Than-Expected Combinations of Drugs and Events in the US FDA's Spontaneous Reports Database Drug Safety, 2002, 25, 381-392.

}
\examples{
## start
#data(PhViDdata.frame)


#PhViDdata <- as.PhViD(PhViDdata.frame)
#res <- GPS(PhViDdata)

#List of signals generated by the decision rule proposed 
#by Szarfman et al. (2002)
#res2 <- GPS(PhViDdata, DECISION = 3, DECISION.THRES = 2, RANKSTAT = 2)
## end
}
\author{\enc{Ismaïl}{Ismail} Ahmed & Antoine Poncet}
\keyword{ htest }

