% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{data_wae_is_short}
\alias{data_wae_is_short}
\title{Walleye data with incomplete stratification with no covariates and condensed}
\format{
\code{data_wae_is_short}
A data frame with many rows and 2 columns

\describe{
\item{\code{cap_hist}.}{Capture history with possible histories as noted below}
\item{\code{freq}.}{Number of fish with this history.}
}
}
\usage{
data(data_wae_is_short)
}
\description{
Data used in
Premarathna, W.A.L., Schwarz, C.J., Jones, T.S. (2018)
Partial stratification in two-sample capture–recapture experiments.
Environmetrics, 29:e2498. https://doi.org/10.1002/env.2498
}
\details{
Data is slightly different from that in paper above because some fish did not
have length measured and so were drop from data_wae_is_long and this is the
condensed version of data_wae_is_long.

Fish were tagged on the spawning grounds and
recovered in the summer gillnet assessment.

Rather than sexing all of the fish, only a sub-sample of unmarked fish
is sexed at each sampling occasion. Possible capture histories are then
M0, F0, MM, FF, U0, UU, 0M, 0F
}
\keyword{datasets}
