% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VaR.R
\name{VaR}
\alias{VaR}
\alias{VaR.CornishFisher}
\title{calculate various Value at Risk (VaR) measures}
\usage{
VaR(R = NULL, p = 0.95, ..., method = c("modified", "gaussian",
  "historical", "kernel"), clean = c("none", "boudt", "geltner"),
  portfolio_method = c("single", "component", "marginal"),
  weights = NULL, mu = NULL, sigma = NULL, m3 = NULL, m4 = NULL,
  invert = TRUE)
}
\arguments{
\item{R}{an xts, vector, matrix, data frame, timeSeries or zoo object of
asset returns}

\item{p}{confidence level for calculation, default p=.95}

\item{\dots}{any other passthru parameters}

\item{method}{one of "modified","gaussian","historical", "kernel", see
Details.}

\item{clean}{method for data cleaning through \code{\link{Return.clean}}.
Current options are "none", "boudt", or "geltner".}

\item{portfolio_method}{one of "single","component","marginal" defining
whether to do univariate, component, or marginal calc, see Details.}

\item{weights}{portfolio weighting vector, default NULL, see Details}

\item{mu}{If univariate, mu is the mean of the series. Otherwise mu is the
vector of means of the return series, default NULL, see Details}

\item{sigma}{If univariate, sigma is the variance of the series. Otherwise
sigma is the covariance matrix of the return series, default NULL, see
Details}

\item{m3}{If univariate, m3 is the skewness of the series. Otherwise m3 is
the coskewness matrix (or vector with unique coskewness values) of the 
returns series, default NULL, see Details}

\item{m4}{If univariate, m4 is the excess kurtosis of the series. Otherwise
m4 is the cokurtosis matrix (or vector with unique cokurtosis values) of the 
return series, default NULL, see Details}

\item{invert}{TRUE/FALSE whether to invert the VaR measure.  see Details.}
}
\description{
Calculates Value-at-Risk(VaR) for univariate, component, and marginal cases
using a variety of analytical methods.
}
\note{
The option to \code{invert} the VaR measure should appease both
academics and practitioners.  The mathematical definition of VaR as the
negative value of a quantile will (usually) produce a positive number.
Practitioners will argue that VaR denotes a loss, and should be internally
consistent with the quantile (a negative number).  For tables and charts,
different preferences may apply for clarity and compactness.  As such, we
provide the option, and set the default to TRUE to keep the return
consistent with prior versions of PerformanceAnalytics, but make no value
judgment on which approach is preferable.

The prototype of the univariate Cornish Fisher VaR function was completed by
Prof. Diethelm Wuertz.  All corrections to the calculation and error
handling are the fault of Brian Peterson.
}
\examples{

    data(edhec)

    # first do normal VaR calc
    VaR(edhec, p=.95, method="historical")

    # now use Gaussian
    VaR(edhec, p=.95, method="gaussian")

    # now use modified Cornish Fisher calc to take non-normal distribution into account
    VaR(edhec, p=.95, method="modified")

    # now use p=.99
    VaR(edhec, p=.99)
    # or the equivalent alpha=.01
    VaR(edhec, p=.01)

    # now with outliers squished
    VaR(edhec, clean="boudt")

    # add Component VaR for the equal weighted portfolio
    VaR(edhec, clean="boudt", portfolio_method="component")

}
\references{
Boudt, Kris, Peterson, Brian, and Christophe Croux. 2008.
Estimation and decomposition of downside risk for portfolios with non-normal
returns. 2008. The Journal of Risk, vol. 11, 79-103.

Cont, Rama, Deguest, Romain and Giacomo Scandolo. Robustness and sensitivity
analysis of risk measurement procedures. Financial Engineering Report No.
2007-06, Columbia University Center for Financial Engineering.

Denton M. and Jayaraman, J.D. Incremental, Marginal, and Component VaR.
Sunguard. 2004.

Epperlein, E., Smillie, A. Cracking VaR with kernels. RISK, 2006, vol.  19,
70-74.

Gourieroux, Christian, Laurent, Jean-Paul and Olivier Scaillet.  Sensitivity
analysis of value at risk. Journal of Empirical Finance, 2000, Vol. 7,
225-245.

Keel, Simon and Ardia, David. Generalized marginal risk. Aeris CAPITAL
discussion paper.

Laurent Favre and Jose-Antonio Galeano. Mean-Modified Value-at-Risk
Optimization with Hedge Funds. Journal of Alternative Investment, Fall 2002,
v 5.

Martellini, L. and Ziemann, V., 2010. Improved estimates of higher-order 
comoments and implications for portfolio selection. Review of Financial 
Studies, 23(4):1467-1502.

Return to RiskMetrics: Evolution of a Standard
\url{https://www.msci.com/documents/10199/dbb975aa-5dc2-4441-aa2d-ae34ab5f0945}

Zangari, Peter. A VaR Methodology for Portfolios that include Options. 1996.
RiskMetrics Monitor, First Quarter, 4-12.

Rockafellar, Terry and Uryasev, Stanislav. Optimization of Conditional VaR.
The Journal of Risk, 2000, vol. 2, 21-41.

Dowd, Kevin. Measuring Market Risk, John Wiley and Sons, 2010.

Jorian, Phillippe. Value at Risk, the new benchmark for managing financial risk.
3rd Edition, McGraw Hill, 2006.

Hallerback, John. "Decomposing Portfolio Value-at-Risk: A General Analysis",
2003. The Journal of Risk vol 5/2.

Yamai and Yoshiba (2002). "Comparative Analyses of Expected Shortfall and 
   Value-at-Risk: Their Estimation Error, Decomposition, and Optimization",
   Bank of Japan.
}
\seealso{
\code{\link{SharpeRatio.modified}} \cr
\code{\link{chart.VaRSensitivity}} \cr
\code{\link{Return.clean}}
}
\author{
Brian G. Peterson and Kris Boudt
}
