% Generated by roxygen2 (4.0.2): do not edit by hand
\name{chart.ECDF}
\alias{chart.ECDF}
\title{Create an ECDF overlaid with a Normal CDF}
\usage{
chart.ECDF(R, main = "Empirical CDF", xlab = "x", ylab = "F(x)",
  colorset = c("black", "#005AFF"), lwd = 1, lty = c(1, 1),
  element.color = "darkgray", xaxis = TRUE, yaxis = TRUE, ...)
}
\arguments{
\item{R}{an xts, vector, matrix, data frame, timeSeries or zoo object of
asset returns}

\item{main}{set the chart title, same as in \code{\link{plot}}}

\item{xlab}{set the x-axis label, same as in \code{\link{plot}}}

\item{ylab}{set the y-axis label, same as in \code{\link{plot}}}

\item{colorset}{color palette to use, defaults to c("black", "\#005AFF"),
where first value is used to color the step function and the second color is
used for the fitted normal}

\item{lwd}{set the line width, same as in \code{\link{plot}}}

\item{lty}{set the line type, same as in \code{\link{plot}}}

\item{element.color}{specify the color of chart elements.  Default is
"darkgray"}

\item{xaxis}{if true, draws the x axis}

\item{yaxis}{if true, draws the y axis}

\item{\dots}{any other passthru parameters to \code{\link{plot}}}
}
\description{
Creates an emperical cumulative distribution function (ECDF) overlaid with a
cumulative distribution function (CDF)
}
\details{
The empirical cumulative distribution function (ECDF for short) calculates
the fraction of observations less or equal to a given value.  The resulting
plot is a step function of that fraction at each observation.  This function
uses \code{ecdf} and overlays the CDF for a fitted normal function as well.
Inspired by a chart in Ruppert (2004).
}
\examples{
data(edhec)
chart.ECDF(edhec[, 1, drop=FALSE])
}
\author{
Peter Carl
}
\references{
Ruppert, David. \emph{Statistics and Finance, an Introduction}.
Springer. 2004. Ch. 2 Fig. 2.5

\url{http://www.stat.tamu.edu/~ljin/Finance/chapter2/Fig2_5.txt}
}
\seealso{
\code{\link{plot}}, \code{\link{ecdf}}
}

