## ------------------------------------------------------------------------
library(Perc)

# displaying the first 5 rows of the example data.
head(sampleEdgelist, 5)

## ------------------------------------------------------------------------
# displaying the first 5 rows of the example data.
head(sampleWeightedEdgelist, 5)

## ------------------------------------------------------------------------
# displaying the first 5 rows and columns
sampleRawMatrix[1:5, 1:5]

## ------------------------------------------------------------------------
# convert an two-column edgelist to conflict matrix
confmatrix <- as.conflictmat(sampleEdgelist)

# displaying the first 5 rows and columns of the converted matrix
confmatrix[1:5, 1:5]

## ------------------------------------------------------------------------
# convert a win-loss matrix to conflict matrix
confmatrix2 <- as.conflictmat(sampleRawMatrix)

# displaying the first 5 rows and columns of the converted matrix
confmatrix2[1]

## ------------------------------------------------------------------------
confmatrix3 <- as.conflictmat(sampleWeightedEdgelist, weighted = TRUE)

## ------------------------------------------------------------------------
# displaying the first 5 rows and columns of the raw win-loss matrix
sampleRawMatrix[1:5, 1:5]

# use swap.order = TRUE when running as.conflictmat.
confmatrix4 <- as.conflictmat(sampleRawMatrix, swap.order = TRUE)

# displaying the first 5 rows and columns of the converted matrix
confmatrix4[1:5, 1:5]


## ------------------------------------------------------------------------
# Testing findIDpaths.R
pathKuai <- findIDpaths(confmatrix, "Kuai", len = 3)
# Displaying the first 5 rows of pathKuai
pathKuai[1:5, ]

# When there's no pathway starting at a particular individual, you'll get an output like the example below: 
pathKalani <- findIDpaths(confmatrix, ID = "Kalani", len = 2)

## ------------------------------------------------------------------------
conftrans <- transitivity(confmatrix)
conftrans$transitive      # number of transitive triangles
conftrans$intransitive    # number of intransitive triangles
conftrans$transitivity    # transitivity
conftrans$alpha           # alpha

## ------------------------------------------------------------------------
DominanceProbability <- conductance(confmatrix, maxLength = 2)

## ------------------------------------------------------------------------
# displaying the first 5 rows and columns of the original conflict matrix
confmatrix[1:5, 1:5]
# displaying the first 5 rows and columns of the imputed conflict matrix
DominanceProbability$imputed.conf[1:5, 1:5]

## ------------------------------------------------------------------------
# substracting the original conflict matrix from imputed conflict matrix.
informationGain <- DominanceProbability$imputed.conf - confmatrix

# examine the first five rows and columns of the informationGain
informationGain[1:5, 1:5]

# generating a heatmap representing information gained by using informatio from indirect pathways.
plotConfmat(informationGain, ordering = NA, labels = TRUE)

## ------------------------------------------------------------------------
DominanceProbabilityLength3 <- conductance(confmatrix, maxLength = 3)
informationGain2 <- DominanceProbabilityLength3$imputed.conf - DominanceProbability$imputed.conf
plotConfmat(informationGain2, ordering = NA, labels = TRUE)

## ------------------------------------------------------------------------
# displaying the first 5 rows and columns of the dominance probability matrix
DominanceProbability$p.hat[1:5, 1:5]

## ------------------------------------------------------------------------
# displaying the first 5 rows of the converted long format win-loss probability.
dyadicLongConverter(DominanceProbability$p.hat)[1:5, ]

## ------------------------------------------------------------------------
# find simRankOrder
s.rank <- simRankOrder(DominanceProbability$p.hat, num = 10, kmax = 10)

## ------------------------------------------------------------------------
# displaying the first 5 rows of the simulated rank order
s.rank$BestSimulatedRankOrder[1:5, ]

# displaying cost for each simulated annealing run
s.rank$Costs

# rank orders generated by each simulated annealing run 
s.rank$AllSimulatedRankOrder

## ------------------------------------------------------------------------
plotConfmat(DominanceProbability$p.hat, ordering = s.rank[[1]]$ID, labels = TRUE)

## ------------------------------------------------------------------------
# displaying the first 5 rows and columns of the converted matrix
valueConverter(DominanceProbability$p.hat)[1:5, 1:5]

## ------------------------------------------------------------------------
# displaying the first 5 rows of Ranking Certainty
dyadicLongConverter(DominanceProbability$p.hat)[1:5, c("ID1", "ID2", "RankingCertainty")]

## ------------------------------------------------------------------------
individualDomProb(DominanceProbability$p.hat)[1:10,]

